/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jprofilegrid.presenter.ColorManager;
import jxl.format.Colour;
import jxl.format.RGB;

public class ColorComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -2820626580393810546L;

    public ColorComboBoxRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value.toString());
        Colour[] allAvailableColors = ColorManager.getSortedColours();
        for (int i = 0; i < allAvailableColors.length; ++i) {
            if (value.toString().equalsIgnoreCase("Load Alignment") || !allAvailableColors[i].getDescription().equalsIgnoreCase(((Colour)value).getDescription())) continue;
            this.setText(ColorComboBoxRenderer.toTitleCase(allAvailableColors[i].getDescription()));
            RGB currentColor = allAvailableColors[i].getDefaultRGB();
            this.setBackground(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
            if ((double)allAvailableColors[i].getDefaultRGB().getGreen() < 153.0) {
                this.setForeground(Color.WHITE);
                continue;
            }
            this.setForeground(Color.BLACK);
        }
        return this;
    }

    public static String toTitleCase(String string) {
        String newString = "";
        boolean cap = true;
        for (int i = 0; i < string.length(); ++i) {
            newString = cap ? newString + String.valueOf(string.charAt(i)).toUpperCase() : newString + string.charAt(i);
            cap = newString.substring(newString.length() - 1, newString.length()).equalsIgnoreCase(" ");
        }
        return newString;
    }
}

