/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JFrame;

public class OpenWindowsMenu
extends Menu
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = -101463428408916847L;
    private static Vector<JFrame> currentlyOpenWindows = new Vector();
    private Vector<MenuItem> menuItems = new Vector();

    public OpenWindowsMenu() {
        super("Window");
    }

    public void updateOpenWindows() {
        this.removeAll();
        this.menuItems = new Vector();
        for (int i = 0; i < currentlyOpenWindows.size(); ++i) {
            MenuItem currentWindow = new MenuItem(currentlyOpenWindows.get(i).getTitle());
            this.menuItems.add(currentWindow);
            currentWindow.addActionListener(this);
            this.add(currentWindow);
        }
    }

    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.menuItems.size(); ++i) {
            if (e.getSource() != this.menuItems.get(i)) continue;
            currentlyOpenWindows.get(i).toFront();
        }
    }

    public void windowActivated(WindowEvent e) {
        if (!currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.add((JFrame)e.getSource());
        }
        this.updateOpenWindows();
    }

    public void windowClosed(WindowEvent e) {
        if (currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.remove((JFrame)e.getSource());
        }
        this.updateOpenWindows();
    }

    public void windowClosing(WindowEvent e) {
        if (currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.remove((JFrame)e.getSource());
        }
        this.updateOpenWindows();
    }

    public void windowOpened(WindowEvent e) {
        if (!currentlyOpenWindows.contains((JFrame)e.getSource())) {
            currentlyOpenWindows.add((JFrame)e.getSource());
        }
        this.updateOpenWindows();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }
}

