/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.alignmentwindow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;

public class AlignmentWindow
extends JFrame
implements ActionListener,
AdjustmentListener {
    private static final long serialVersionUID = 1L;
    private JTextArea speciesNamesJTextArea = new JTextArea();
    private JTextArea alignmentJTextArea = new JTextArea();
    private JScrollPane speciesNameScrollPane = new JScrollPane(this.speciesNamesJTextArea);
    private JScrollPane sequenceScrollPane = new JScrollPane(this.alignmentJTextArea);
    private JScrollBar verticalSequenceBar = new JScrollBar(1);
    private JScrollBar horizontalSequenceBar = new JScrollBar(0);
    private JScrollBar verticalSpeciesBar = new JScrollBar(1);
    private JScrollBar horizontalSpeciesBar = new JScrollBar(0);
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private int horizontalScrollPosition;
    private int verticalScrollPosition;
    private ProfileGridPresenter profileGridPresenter;
    private static Dimension DEFAULT_DIMENSION = new Dimension(300, 200);

    public AlignmentWindow(ProfileGridPresenter profileGridPresenter) {
        super("Alignment");
        this.setDefaultCloseOperation(1);
        this.profileGridPresenter = profileGridPresenter;
        this.speciesNamesJTextArea.setAlignmentX(1.0f);
        this.verticalSpeciesBar.addAdjustmentListener(this);
        this.verticalSequenceBar.addAdjustmentListener(this);
        this.speciesNameScrollPane.setVerticalScrollBarPolicy(21);
        this.sequenceScrollPane.setVerticalScrollBar(this.verticalSequenceBar);
        this.sequenceScrollPane.setHorizontalScrollBar(this.horizontalSequenceBar);
        this.speciesNameScrollPane.setVerticalScrollBar(this.verticalSpeciesBar);
        this.speciesNameScrollPane.setHorizontalScrollBar(this.horizontalSpeciesBar);
        this.alignmentJTextArea.setBackground(this.getBackground());
        this.alignmentJTextArea.setFont(new Font("COURIER", 0, 16));
        this.alignmentJTextArea.setEditable(false);
        this.speciesNamesJTextArea.setBackground(this.getBackground());
        this.speciesNamesJTextArea.setFont(new Font("COURIER", 0, 16));
        this.speciesNamesJTextArea.setEditable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);
        constraints.fill = 1;
        constraints.weightx = 10.0;
        constraints.weighty = 1.0;
        this.add((Component)this.speciesNameScrollPane, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 90.0;
        this.add((Component)this.sequenceScrollPane, constraints);
        this.setSize(DEFAULT_DIMENSION);
        this.initializeMenuBar();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void updateSequences(String newText) {
        this.horizontalScrollPosition = this.horizontalSequenceBar.getValue();
        this.verticalScrollPosition = this.verticalSequenceBar.getValue();
        this.alignmentJTextArea.setText(newText);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AlignmentWindow.this.horizontalSequenceBar.setValue(AlignmentWindow.this.horizontalScrollPosition);
                AlignmentWindow.this.verticalSequenceBar.setValue(AlignmentWindow.this.verticalScrollPosition);
            }
        });
    }

    public void updateNames(String newText) {
        this.speciesNamesJTextArea.setText(newText);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (e.getSource() == this.aboutMenuItem) {
            this.profileGridPresenter.showAboutDialog();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.verticalSequenceBar) {
            this.verticalSpeciesBar.setValue(this.verticalSequenceBar.getValue());
        }
    }
}

