/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.celldescription;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;

public class CellDescriptionJFrame
extends JFrame
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 503347149005198654L;
    private JTextArea currentSelectedCell = new JTextArea("Select Cell");
    private JScrollPane scrollPane = new JScrollPane(this.currentSelectedCell);
    private JScrollBar verticalBar = new JScrollBar(1);
    private JScrollBar horizontalBar = new JScrollBar(0);
    private JButton showAlignmentJButton = new JButton("Show Alignment");
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private Menu editMenu = new Menu("Edit");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private MenuItem copyItem = new MenuItem("Copy Sequence List");
    private ProfileGridPresenter profileGridPresenter;

    public CellDescriptionJFrame(ProfileGridPresenter profileGridPresenter) {
        super("Sequences");
        this.profileGridPresenter = profileGridPresenter;
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);
        this.initializeMenuBar();
        this.scrollPane.setVerticalScrollBar(this.verticalBar);
        this.scrollPane.setHorizontalScrollBar(this.horizontalBar);
        this.currentSelectedCell.setEditable(false);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.scrollPane, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)this.showAlignmentJButton, constraints);
        this.showAlignmentJButton.addActionListener(this);
        this.setSize(150, 300);
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.editMenu.add(this.copyItem);
        this.copyItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void setVisible(boolean visible) {
        this.currentSelectedCell.setBackground(this.getBackground());
        super.setVisible(visible);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (e.getSource() == this.aboutMenuItem) {
            this.profileGridPresenter.showAboutDialog();
        }
        if (e.getSource() == this.copyItem) {
            this.copySelectedText();
        }
        if (e.getSource() == this.showAlignmentJButton) {
            this.profileGridPresenter.showAlignmentWindow();
        }
    }

    public void copySelectedText() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.currentSelectedCell.getText()), this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public JTextArea getSequenceListJTextArea() {
        return this.currentSelectedCell;
    }
}

