/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.frequencycolors;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.presenter.ColorManager;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.ColorComboBoxRenderer;
import jprofilegrid.view.OpenWindowsMenu;
import jxl.format.Colour;
import jxl.format.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyColorsJFrame
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -9206173067242992333L;
    private JComboBox numberOfThresholds = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6});
    private GridBagLayout mainLayout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private Vector<JTextField> thresholdValues = new Vector();
    private Vector<JComboBox> colorBoxes = new Vector();
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private JLabel colorSetsJLabel = new JLabel("Color Set:");
    private JComboBox colorSetsJComboBox = new JComboBox<String>(ConservationRange.COLOR_SET_NAMES);
    private ProfileGridPresenter profileGridPresenter;

    public FrequencyColorsJFrame(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
        this.setDefaultCloseOperation(1);
        this.setTitle("Frequency Colors");
        this.setLayout(this.mainLayout);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.initializeMenuBar();
        this.initializeNumberOfThresholdsBlank();
        this.initializeColorBlanks();
        ++this.constraints.gridy;
        this.constraints.gridx = 0;
        this.add((Component)this.colorSetsJLabel, this.constraints);
        ++this.constraints.gridx;
        this.colorSetsJComboBox.addActionListener(this);
        this.add((Component)this.colorSetsJComboBox, this.constraints);
        this.setResizable(false);
        this.pack();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    private void initializeNumberOfThresholdsBlank() {
        this.constraints.gridwidth = 2;
        JPanel thresholdNumPanel = new JPanel(new FlowLayout());
        thresholdNumPanel.add(new JLabel("Number of Bins:"));
        this.numberOfThresholds.setSelectedIndex(ConservationRange.getDefaultConservationColors().length - 1);
        this.numberOfThresholds.addActionListener(this);
        thresholdNumPanel.add(this.numberOfThresholds);
        this.add((Component)thresholdNumPanel, this.constraints);
    }

    private void initializeColorBlanks() {
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.initializeLayout();
        this.initializeLabels();
        for (int i = 0; i < ConservationRange.getDefaultConservationColors().length; ++i) {
            this.addRange(ConservationRange.DEFAULT_CONSERVATION_RANGES[i], ConservationRange.getDefaultConservationColors()[i]);
        }
        this.addKeyListeners();
        this.addActionListeners();
    }

    private void initializeLayout() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.anchor = 10;
    }

    private void initializeLabels() {
        this.add((Component)new JLabel("Threshold:"), this.constraints);
        ++this.constraints.gridx;
        this.add((Component)new JLabel("Color:"), this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
    }

    private void addRange(Double value, Colour colour) {
        this.thresholdValues.add(new JTextField(String.valueOf(value), 5));
        this.add((Component)this.thresholdValues.get(this.thresholdValues.size() - 1), this.constraints);
        ++this.constraints.gridx;
        this.colorBoxes.add(new JComboBox<Colour>(ColorManager.getSortedColours()));
        this.colorBoxes.get(this.colorBoxes.size() - 1).setRenderer(new ColorComboBoxRenderer());
        this.colorBoxes.get(this.colorBoxes.size() - 1).setSelectedIndex(ColorManager.getColorIndexWithName(colour.getDescription()));
        this.add((Component)this.colorBoxes.get(this.colorBoxes.size() - 1), this.constraints);
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
    }

    private void addKeyListeners() {
        for (int i = 0; i < this.thresholdValues.size(); ++i) {
            this.thresholdValues.get(i).addKeyListener(this);
        }
    }

    private void addActionListeners() {
        for (int i = 0; i < this.colorBoxes.size(); ++i) {
            RGB currentColor = ColorManager.getSortedColours()[this.colorBoxes.get(i).getSelectedIndex()].getDefaultRGB();
            this.colorBoxes.get(i).setForeground(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
            this.colorBoxes.get(i).setSelectedIndex(this.colorBoxes.get(i).getSelectedIndex());
            this.colorBoxes.get(i).addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.numberOfThresholds) {
            this.profileGridPresenter.updateActiveBins();
            return;
        }
        if (e.getSource() == this.quitMenuItem) {
            System.exit(0);
            return;
        }
        if (e.getSource() == this.aboutMenuItem) {
            this.profileGridPresenter.showAboutDialog();
            return;
        }
        for (int i = 0; i < this.colorBoxes.size(); ++i) {
            if (e.getSource() != this.colorBoxes.get(i)) continue;
            RGB currentColor = ColorManager.getSortedColours()[this.colorBoxes.get(i).getSelectedIndex()].getDefaultRGB();
            this.colorBoxes.get(i).setForeground(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
            this.profileGridPresenter.updateTopProfileGrid();
            return;
        }
        if (e.getSource() == this.colorSetsJComboBox) {
            int selectedColorSet = this.colorSetsJComboBox.getSelectedIndex();
            Colour[] colorSet = ConservationRange.COLOR_SETS[selectedColorSet];
            for (int i = 0; i < colorSet.length; ++i) {
                JComboBox colorBox = this.colorBoxes.get(i);
                colorBox.removeActionListener(this);
                int colorIndex = ColorManager.getColorIndexWithName(colorSet[i].getDescription());
                colorBox.setSelectedIndex(colorIndex);
                RGB currentColor = ColorManager.getSortedColours()[colorIndex].getDefaultRGB();
                colorBox.setForeground(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
                colorBox.addActionListener(this);
            }
            this.profileGridPresenter.updateTopProfileGrid();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.profileGridPresenter.updateTopProfileGrid();
    }

    public JComboBox getNumberOfBinsJComboBox() {
        return this.numberOfThresholds;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public Vector<JTextField> getThresholdValueJTextFields() {
        return this.thresholdValues;
    }

    public Vector<JComboBox> getColorValuesJComboBoxes() {
        return this.colorBoxes;
    }
}

