/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.gridparameters;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.presenter.SortableSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrepSequenceJComboBox
extends JComboBox
implements KeyListener {
    private static final long serialVersionUID = 790268930757172746L;
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private List<Sequence> sortedSequences = new ArrayList<Sequence>();

    public GrepSequenceJComboBox() {
        this.setModel(new DefaultComboBoxModel<String>(new String[]{"Load Alignment                 "}));
        this.getEditor().getEditorComponent().addKeyListener(this);
    }

    public void setSequenceListSorted(boolean sorted) {
        super.removeAllItems();
        List<Sequence> displayedSequences = sorted ? this.sortedSequences : this.sequences;
        for (Sequence sequence : displayedSequences) {
            super.addItem(sequence.getName());
        }
    }

    public void setSequences(List<Sequence> sequences) {
        this.removeAllItems();
        PriorityQueue<SortableSequence> sequenceSortingQueue = new PriorityQueue<SortableSequence>();
        for (int i = 0; i < sequences.size(); ++i) {
            Sequence sequence = sequences.get(i);
            this.sequences.add(sequence);
            sequenceSortingQueue.add(new SortableSequence(sequence, i));
            super.addItem(sequence.getName());
        }
        while (!sequenceSortingQueue.isEmpty()) {
            this.sortedSequences.add(((SortableSequence)sequenceSortingQueue.remove()).getSequence());
        }
        this.setMaximumSize(this.getSize());
        this.setMinimumSize(this.getSize());
        this.setPreferredSize(this.getSize());
    }

    public Sequence getSelectedSequence() {
        if (super.getSelectedItem() != null) {
            String selectedValue = super.getSelectedItem().toString();
            for (int i = 0; i < this.sequences.size(); ++i) {
                Sequence sequence = this.sequences.get(i);
                if (!selectedValue.equalsIgnoreCase(sequence.getName())) continue;
                return sequence;
            }
        }
        return null;
    }

    public int getSelectedSequenceIndex() {
        if (super.getSelectedItem() != null) {
            String selectedValue = super.getSelectedItem().toString();
            for (int i = 0; i < this.sequences.size(); ++i) {
                Sequence sequence = this.sequences.get(i);
                if (!selectedValue.equalsIgnoreCase(sequence.getName())) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public void removeAllItems() {
        this.sequences.clear();
        this.sortedSequences.clear();
        super.removeAllItems();
    }

    private void filterItemsList(String filter) {
        ActionListener[] actionListeners;
        for (ActionListener actionListener : actionListeners = this.getActionListeners()) {
            this.removeActionListener(actionListener);
        }
        super.removeAllItems();
        ArrayList<String> matchingItems = new ArrayList<String>();
        try {
            Pattern pattern = Pattern.compile(filter);
            for (Sequence sequence : this.sequences) {
                String sequenceName = sequence.getName();
                if (!pattern.matcher(sequenceName).find()) continue;
                matchingItems.add(sequenceName);
            }
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.setModel(new DefaultComboBoxModel<Object>(matchingItems.toArray()));
        for (ActionListener actionListener : actionListeners) {
            this.addActionListener(actionListener);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c >= ' ' && c <= '\u007f' || c == '\b') {
            this.hidePopup();
            JTextField editorJTextField = (JTextField)this.getEditor().getEditorComponent();
            String currVal = editorJTextField.getText();
            this.filterItemsList(currVal);
            editorJTextField.setText(currVal);
            this.showPopup();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

