/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.gridparameters;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.gridparameters.GrepSequenceJComboBox;

public class GridParametersJPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 4477656123215277926L;
    private static final int SHOW_VALUES_DISABLED = 3;
    private GridBagConstraints constraints = new GridBagConstraints();
    private GridBagLayout anaylzePanelOptionsAreaLayout = new GridBagLayout();
    private Border border = new LineBorder(new Color(0, 100, 0), 1);
    private TitledBorder analyzePanelBorder = BorderFactory.createTitledBorder(this.border, "Grid Parameters");
    private JTextField startAtBlank = new JTextField(String.valueOf(1), 5);
    private GrepSequenceJComboBox referenceSequenceBlank = new GrepSequenceJComboBox();
    private JComboBox sortTypeBlank = new JComboBox<String>(new String[]{"Load Alignment            "});
    private JComboBox integerOrPercentageOrResidue = new JComboBox<String>(new String[]{"Integer", "Percentage", "Residue"});
    private JComboBox identifySeqIfResIsAbsOrPres = new JComboBox<String>(new String[]{"Present", "Absent"});
    private JTextArea identifySeqLabel = new JTextArea("Identify sequences where\nselected residue is:");
    private JCheckBox frequencyColorsJCheckBox = new JCheckBox();
    private JCheckBox ascendingJCheckBox = new JCheckBox();
    private JCheckBox skipGapsJCheckBox = new JCheckBox();
    private JCheckBox showValuesJCheckBox = new JCheckBox();
    private JCheckBox sortSequenceListsJCheckBox = new JCheckBox();
    private JCheckBox metaDataJCheckBox = new JCheckBox();
    private JButton frequencyColorsButton = new JButton("Frequency Colors");
    private JButton identifySequencesButton = new JButton("Sequences");
    private JButton profileGridOverviewTypeJButton = new JButton("ProfileGrid");
    private JButton alignmentOverviewTypeJButton = new JButton("Alignment");
    private JButton highlightJButton = new JButton("Highlighting");
    private JButton metaDataJButton = new JButton("Meta Data");
    private JLabel sortSequenceListsJLabel = new JLabel("Sort Sequence Lists:");
    private JLabel referenceSequenceLabel = new JLabel("Reference Sequence:");
    private JLabel positionRulerLabel = new JLabel("Position Ruler:");
    private JLabel skipGapsLabel = new JLabel("Skip Gaps");
    private JLabel startAtLabel = new JLabel("Start At");
    private JLabel sortAscendingAndTypeLabel = new JLabel("Sort Ascending/Type:");
    private JLabel enableFrequencyColorsLabel = new JLabel("Frequency Colors:");
    private JLabel showValuesLabel = new JLabel("Show Values:");
    private JLabel overviewLabel = new JLabel("Show Overview:");
    private JLabel highlightJLabel = new JLabel("Highlighting:");
    private JLabel metaDataJLabel = new JLabel("Enable Meta Data Filters:");
    private JPanel positionRulerJPanel = new JPanel(new GridBagLayout());
    private JPanel frequencyColorsJPanel = new JPanel(new GridBagLayout());
    private JPanel sortAndDualDisplayJPanel = new JPanel(new GridBagLayout());
    private JPanel overviewTypesJPanel = new JPanel(new GridBagLayout());
    private ProfileGridPresenter profileGridPresenter;

    public GridParametersJPanel(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.highlightJButton) {
            this.profileGridPresenter.openHighlightJFrame();
            return;
        }
        if (s == this.sortSequenceListsJCheckBox) {
            this.profileGridPresenter.updateSortSequenceLists();
            return;
        }
        if (s == this.frequencyColorsButton) {
            this.profileGridPresenter.showFrequencyColorsSelectionJFrame();
            return;
        }
        if (s == this.profileGridOverviewTypeJButton) {
            this.profileGridPresenter.showProfileGridOverviewJFrame();
            return;
        }
        if (s == this.identifySequencesButton) {
            this.profileGridPresenter.openIdentifySequencesDialog();
            return;
        }
        if (s == this.identifySeqIfResIsAbsOrPres) {
            this.profileGridPresenter.setSelectedAminoAcid();
            return;
        }
        if (s == this.alignmentOverviewTypeJButton) {
            this.profileGridPresenter.showAlignmentOverviewJFrame();
            return;
        }
        if (s == this.metaDataJButton) {
            this.profileGridPresenter.showMetaDataColumnsJFrame();
            return;
        }
        if (s == this.sortTypeBlank || s == this.ascendingJCheckBox) {
            this.profileGridPresenter.recalculateSorting();
            return;
        }
        if (s == this.metaDataJCheckBox) {
            this.profileGridPresenter.onFilterchange();
            return;
        }
        this.profileGridPresenter.updateTopProfileGrid();
    }

    public void initializeAnalyzePanel() {
        this.analyzePanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(this.analyzePanelBorder);
        this.setLayout(this.anaylzePanelOptionsAreaLayout);
        this.addListeners();
        this.identifySeqLabel.setBackground(this.getBackground());
        this.identifySeqLabel.setFont(this.sortSequenceListsJLabel.getFont());
        this.identifySeqLabel.setEditable(false);
        this.skipGapsJCheckBox.setSelected(true);
        this.frequencyColorsJCheckBox.setSelected(true);
        this.ascendingJCheckBox.setSelected(true);
        this.showValuesJCheckBox.setSelected(true);
        this.initializeLabels();
        GridBagConstraintsInitializer.resetConstraints(this.constraints);
        this.initializeSortAndDualDisplayJPanel();
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 4;
        this.add((Component)this.referenceSequenceBlank, this.constraints);
        this.constraints.anchor = 21;
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 10;
        this.referenceSequenceBlank.setEditable(true);
        this.add((Component)this.sortAndDualDisplayJPanel, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.highlightJButton.addActionListener(this);
        this.add((Component)this.highlightJButton, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.initializePositionRulerJPanel();
        this.add((Component)this.positionRulerJPanel, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 10;
        this.constraints.gridy = 4;
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.add((Component)this.ascendingJCheckBox, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridwidth = 4;
        this.add((Component)this.sortTypeBlank, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.add((Component)this.frequencyColorsJCheckBox, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridwidth = 4;
        this.add((Component)this.frequencyColorsButton, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 1;
        this.add((Component)this.showValuesJCheckBox, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 3;
        this.add((Component)this.integerOrPercentageOrResidue, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.metaDataJCheckBox.addActionListener(this);
        this.metaDataJCheckBox.setSelected(true);
        this.add((Component)this.metaDataJCheckBox, this.constraints);
        ++this.constraints.gridx;
        this.metaDataJButton.addActionListener(this);
        this.add((Component)this.metaDataJButton, this.constraints);
        this.initializeOverviewTypesJPanel();
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 2;
        this.add((Component)this.overviewTypesJPanel, this.constraints);
    }

    private void initializeLabels() {
        GridBagConstraintsInitializer.resetConstraints(this.constraints);
        this.constraints.anchor = 22;
        this.add((Component)this.positionRulerLabel, this.constraints);
        this.constraints.gridy = 2;
        this.constraints.gridheight = 1;
        this.add((Component)this.referenceSequenceLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.sortSequenceListsJLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.highlightJLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.sortAscendingAndTypeLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.enableFrequencyColorsLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.showValuesLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.metaDataJLabel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.overviewLabel, this.constraints);
        this.initializeFrequencyColorsJPanel();
        ++this.constraints.gridy;
        this.constraints.gridwidth = 5;
        this.add((Component)this.frequencyColorsJPanel, this.constraints);
    }

    private void initializeSortAndDualDisplayJPanel() {
        GridBagConstraints sortAndDualDisplayJPanelConstraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(sortAndDualDisplayJPanelConstraints);
        this.constraints.anchor = 21;
        sortAndDualDisplayJPanelConstraints.ipadx = 5;
        sortAndDualDisplayJPanelConstraints.gridx = 0;
        sortAndDualDisplayJPanelConstraints.gridy = 0;
        sortAndDualDisplayJPanelConstraints.gridwidth = 1;
        sortAndDualDisplayJPanelConstraints.gridheight = 1;
        this.sortAndDualDisplayJPanel.add((Component)this.sortSequenceListsJCheckBox, sortAndDualDisplayJPanelConstraints);
        this.sortSequenceListsJCheckBox.addActionListener(this);
    }

    private void initializeOverviewTypesJPanel() {
        GridBagConstraints overviewTypesJPanelConstraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(overviewTypesJPanelConstraints);
        this.constraints.anchor = 21;
        overviewTypesJPanelConstraints.ipadx = 5;
        overviewTypesJPanelConstraints.gridx = 0;
        overviewTypesJPanelConstraints.gridy = 0;
        overviewTypesJPanelConstraints.gridwidth = 1;
        overviewTypesJPanelConstraints.gridheight = 1;
        this.overviewTypesJPanel.add((Component)this.profileGridOverviewTypeJButton, overviewTypesJPanelConstraints);
        this.profileGridOverviewTypeJButton.addActionListener(this);
        ++overviewTypesJPanelConstraints.gridx;
        this.overviewTypesJPanel.add((Component)this.alignmentOverviewTypeJButton, overviewTypesJPanelConstraints);
        this.alignmentOverviewTypeJButton.addActionListener(this);
    }

    private void initializePositionRulerJPanel() {
        GridBagConstraints positionRulerJPanelConstraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(positionRulerJPanelConstraints);
        positionRulerJPanelConstraints.ipadx = 5;
        this.positionRulerJPanel.add((Component)this.skipGapsLabel, positionRulerJPanelConstraints);
        ++positionRulerJPanelConstraints.gridx;
        this.positionRulerJPanel.add((Component)this.startAtLabel, positionRulerJPanelConstraints);
        ++positionRulerJPanelConstraints.gridy;
        positionRulerJPanelConstraints.fill = 2;
        this.positionRulerJPanel.add((Component)this.startAtBlank, positionRulerJPanelConstraints);
        --positionRulerJPanelConstraints.gridx;
        positionRulerJPanelConstraints.fill = 0;
        this.positionRulerJPanel.add((Component)this.skipGapsJCheckBox, positionRulerJPanelConstraints);
    }

    private void initializeFrequencyColorsJPanel() {
        GridBagConstraints frequencyColorsJPanelConstraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(frequencyColorsJPanelConstraints);
        frequencyColorsJPanelConstraints.ipadx = 5;
        frequencyColorsJPanelConstraints.gridwidth = 1;
        frequencyColorsJPanelConstraints.gridheight = 2;
        this.frequencyColorsJPanel.add((Component)this.identifySeqLabel, frequencyColorsJPanelConstraints);
        ++frequencyColorsJPanelConstraints.gridx;
        frequencyColorsJPanelConstraints.gridheight = 1;
        this.frequencyColorsJPanel.add((Component)this.identifySeqIfResIsAbsOrPres, frequencyColorsJPanelConstraints);
        ++frequencyColorsJPanelConstraints.gridx;
        this.frequencyColorsJPanel.add((Component)this.identifySequencesButton, frequencyColorsJPanelConstraints);
    }

    private void addListeners() {
        this.startAtBlank.addKeyListener(this);
        this.skipGapsJCheckBox.addActionListener(this);
        this.ascendingJCheckBox.addActionListener(this);
        this.sortTypeBlank.addActionListener(this);
        this.referenceSequenceBlank.addActionListener(this);
        this.integerOrPercentageOrResidue.addActionListener(this);
        this.showValuesJCheckBox.addActionListener(this);
        this.identifySeqIfResIsAbsOrPres.addActionListener(this);
        this.frequencyColorsButton.addActionListener(this);
        this.frequencyColorsJCheckBox.addActionListener(this);
        this.identifySequencesButton.addActionListener(this);
    }

    public void switchIntegerOrPercentageOrResidue(AnalysisOptions analysisOptions) {
        analysisOptions.showValuesAs = this.showValueAs();
        this.profileGridPresenter.updateTopProfileGrid();
    }

    public void selectPercentage() {
        this.integerOrPercentageOrResidue.removeActionListener(this);
        this.integerOrPercentageOrResidue.setSelectedIndex(1);
        this.integerOrPercentageOrResidue.addActionListener(this);
    }

    public boolean skipGapsEnabled() {
        return this.skipGapsJCheckBox.isSelected();
    }

    public boolean isAscendingSort() {
        return this.ascendingJCheckBox.isSelected();
    }

    public int getSortType() {
        return this.sortTypeBlank.getSelectedIndex();
    }

    public String getSortTypeName() {
        return this.sortTypeBlank.getSelectedItem().toString();
    }

    public int getPositionStart() {
        try {
            return Integer.parseInt(this.startAtBlank.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public boolean frequencyColorsEnabled() {
        return this.frequencyColorsJCheckBox.isSelected();
    }

    public int showValueAs() {
        if (this.showValuesJCheckBox.isSelected()) {
            this.integerOrPercentageOrResidue.setEnabled(true);
            return this.integerOrPercentageOrResidue.getSelectedIndex();
        }
        this.integerOrPercentageOrResidue.setEnabled(false);
        return 3;
    }

    public boolean getDisplayedResidueIfPresent() {
        return this.identifySeqIfResIsAbsOrPres.getSelectedIndex() == 0;
    }

    public void setSortTypeBlank(String[] data) {
        this.sortTypeBlank.removeActionListener(this);
        this.sortTypeBlank.setModel(new DefaultComboBoxModel<String>(data));
        this.sortTypeBlank.addActionListener(this);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.startAtBlank) {
            this.profileGridPresenter.updateTopProfileGrid();
        }
    }

    public void enableFrequencyColorsButton() {
        this.frequencyColorsButton.setEnabled(true);
    }

    public void disableFrequencyColorsButton() {
        this.frequencyColorsButton.setEnabled(false);
    }

    public void keyTyped(KeyEvent e) {
    }

    public JPanel getPositionRulerJPanel() {
        return this.positionRulerJPanel;
    }

    public JPanel getFrequencyColorsJPanel() {
        return this.frequencyColorsJPanel;
    }

    public JPanel getSortAndDualDisplayJPanel() {
        return this.sortAndDualDisplayJPanel;
    }

    public JPanel getOverviewTypesJPanel() {
        return this.overviewTypesJPanel;
    }

    public JCheckBox getSortSequenceListsJCheckBox() {
        return this.sortSequenceListsJCheckBox;
    }

    public GrepSequenceJComboBox getReferenceSequenceBlank() {
        return this.referenceSequenceBlank;
    }

    public boolean getSortingEnabled() {
        return this.sortSequenceListsJCheckBox.isSelected();
    }

    public boolean getMetaDataFilteringEnabled() {
        return this.metaDataJCheckBox.isSelected();
    }
}

