/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.highlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.presenter.ColorManager;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.ColorComboBoxRenderer;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.gridparameters.GrepSequenceJComboBox;
import jxl.format.Colour;
import jxl.format.RGB;

public class HighlightJFrame
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private GrepSequenceJComboBox highlightSequenceBlank = new GrepSequenceJComboBox();
    private JComboBox highlightSequenceColor = new JComboBox<String>(new String[]{"Load Alignment"});
    private JRadioButton sequenceRadioButton = new JRadioButton("Sequence");
    private JRadioButton valuesRadioButton = new JRadioButton("Values");
    private JRadioButton aboveRadioButton = new JRadioButton("\u2265");
    private JRadioButton equalsRadioButton = new JRadioButton("=");
    private JRadioButton belowRadioButton = new JRadioButton("\u2264");
    private JPanel highlightSequenceJPanel = new JPanel();
    private JPanel highlightValuesJPanel = new JPanel();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ButtonGroup aboveBelowGroup = new ButtonGroup();
    private JLabel highlightBasedOnLabel = new JLabel("Highlight Based On: ");
    private JLabel highlightSequenceLabel = new JLabel("Highlight Sequence:");
    private JLabel highlightColorLabel = new JLabel("Highlight Color:");
    private JLabel highlightValuesLabel = new JLabel("Highlight Value:");
    private JTextField highlightValuesJTextField = new JTextField("1", 5);
    private GridBagLayout mainLayout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private ProfileGridPresenter profileGridPresenter;

    public HighlightJFrame(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
        this.highlightValuesJTextField.addKeyListener(this);
        this.buttonGroup.add(this.sequenceRadioButton);
        this.buttonGroup.add(this.valuesRadioButton);
        this.aboveRadioButton.addActionListener(this);
        this.equalsRadioButton.addActionListener(this);
        this.belowRadioButton.addActionListener(this);
        this.aboveRadioButton.setSelected(true);
        this.aboveBelowGroup.add(this.aboveRadioButton);
        this.aboveBelowGroup.add(this.equalsRadioButton);
        this.aboveBelowGroup.add(this.belowRadioButton);
        this.sequenceRadioButton.addActionListener(this);
        this.valuesRadioButton.addActionListener(this);
        this.sequenceRadioButton.setSelected(true);
        this.setTitle("Highlighting");
        this.highlightSequenceColor.setRenderer(new ColorComboBoxRenderer());
        this.setLayout(this.mainLayout);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.initializeMenuBar();
        this.highlightSequenceBlank.setEditable(true);
        this.highlightSequenceBlank.addActionListener(this);
        JPanel radioButtonJPanel = new JPanel();
        radioButtonJPanel.setLayout(new FlowLayout());
        radioButtonJPanel.add(this.highlightBasedOnLabel);
        radioButtonJPanel.add(this.sequenceRadioButton);
        this.constraints.anchor = 10;
        radioButtonJPanel.add(this.valuesRadioButton);
        this.add((Component)radioButtonJPanel, this.constraints);
        JPanel highlightColorJPanel = new JPanel();
        highlightColorJPanel.setLayout(new FlowLayout());
        highlightColorJPanel.add(this.highlightColorLabel);
        highlightColorJPanel.add(this.highlightSequenceColor);
        ++this.constraints.gridy;
        this.add((Component)highlightColorJPanel, this.constraints);
        this.highlightSequenceJPanel.setLayout(new GridBagLayout());
        GridBagConstraints highlightSequenceConstraints = new GridBagConstraints();
        highlightSequenceConstraints.gridx = 0;
        highlightSequenceConstraints.gridy = 0;
        highlightSequenceConstraints.anchor = 22;
        this.highlightSequenceJPanel.add((Component)this.highlightSequenceLabel, highlightSequenceConstraints);
        ++highlightSequenceConstraints.gridx;
        highlightSequenceConstraints.anchor = 21;
        this.highlightSequenceJPanel.add((Component)this.highlightSequenceBlank, highlightSequenceConstraints);
        LineBorder highlightSequenceLineBorder = new LineBorder(new Color(101, 115, 131), 1);
        TitledBorder highlightSequenceTitleBorder = BorderFactory.createTitledBorder(highlightSequenceLineBorder, "Sequence");
        highlightSequenceTitleBorder.setTitleColor(new Color(0, 0, 0));
        this.highlightSequenceJPanel.setBorder(highlightSequenceTitleBorder);
        ++this.constraints.gridy;
        this.add((Component)this.highlightSequenceJPanel, this.constraints);
        this.highlightValuesJPanel.setLayout(new GridBagLayout());
        GridBagConstraints highlightValuesConstraints = new GridBagConstraints();
        highlightValuesConstraints.gridx = 0;
        highlightValuesConstraints.gridy = 0;
        highlightValuesConstraints.anchor = 10;
        JPanel highlightThresholdTypeJPanel = new JPanel();
        highlightThresholdTypeJPanel.setLayout(new FlowLayout());
        highlightThresholdTypeJPanel.add(this.aboveRadioButton);
        highlightThresholdTypeJPanel.add(this.equalsRadioButton);
        highlightThresholdTypeJPanel.add(this.belowRadioButton);
        highlightValuesConstraints.gridwidth = 2;
        this.highlightValuesJPanel.add((Component)highlightThresholdTypeJPanel, highlightValuesConstraints);
        ++highlightValuesConstraints.gridy;
        highlightValuesConstraints.gridwidth = 1;
        this.highlightValuesJPanel.add((Component)this.highlightValuesLabel, highlightValuesConstraints);
        ++highlightValuesConstraints.gridx;
        highlightValuesConstraints.anchor = 21;
        this.highlightValuesJPanel.add((Component)this.highlightValuesJTextField, highlightValuesConstraints);
        LineBorder highlightValuesLineBorder = new LineBorder(new Color(195, 86, 23), 1);
        TitledBorder highlightValuesTitleBorder = BorderFactory.createTitledBorder(highlightValuesLineBorder, "Value");
        highlightValuesTitleBorder.setTitleColor(new Color(0, 0, 0));
        this.highlightValuesJPanel.setBorder(highlightValuesTitleBorder);
        ++this.constraints.gridy;
        this.constraints.fill = 2;
        this.add((Component)this.highlightValuesJPanel, this.constraints);
        this.setResizable(false);
        this.highlightSequenceColor.removeAllItems();
        Colour[] SORTED_COLOURS = ColorManager.getSortedColours();
        for (int i = 0; i < SORTED_COLOURS.length; ++i) {
            this.highlightSequenceColor.addItem(SORTED_COLOURS[i]);
        }
        this.highlightSequenceColor.setSelectedItem(Colour.PINK);
        RGB currentColor = Colour.PINK.getDefaultRGB();
        Color color = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
        this.highlightSequenceColor.setForeground(color);
        this.highlightSequenceColor.addActionListener(this);
        this.pack();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.highlightSequenceColor) {
            RGB currentColor = ColorManager.getSortedColours()[this.highlightSequenceColor.getSelectedIndex()].getDefaultRGB();
            Color color = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
            this.highlightSequenceColor.setForeground(color);
        }
        if (source == this.sequenceRadioButton || source == this.valuesRadioButton) {
            this.profileGridPresenter.onHighlightTypeChanged();
        }
        if (source == this.aboveRadioButton && this.aboveRadioButton.isSelected()) {
            this.profileGridPresenter.onHighlightTypeChanged();
        }
        if (source == this.equalsRadioButton && this.equalsRadioButton.isSelected()) {
            this.profileGridPresenter.onHighlightTypeChanged();
        }
        if (source == this.belowRadioButton && this.belowRadioButton.isSelected()) {
            this.profileGridPresenter.onHighlightTypeChanged();
        }
        this.profileGridPresenter.updateTopProfileGrid();
    }

    public GrepSequenceJComboBox getHighlightSequenceBlank() {
        return this.highlightSequenceBlank;
    }

    public JComboBox getHighlightSequenceColorBlank() {
        return this.highlightSequenceColor;
    }

    public JRadioButton getSequenceRadioButton() {
        return this.sequenceRadioButton;
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.highlightValuesJTextField) {
            this.profileGridPresenter.onHighlightTypeChanged();
            this.profileGridPresenter.updateTopProfileGrid();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public JRadioButton getAboveRadioButton() {
        return this.aboveRadioButton;
    }

    public JRadioButton getEqualsRadioButton() {
        return this.equalsRadioButton;
    }

    public JRadioButton getBelowRadioButton() {
        return this.belowRadioButton;
    }

    public JPanel getHighlightValuesJPanel() {
        return this.highlightValuesJPanel;
    }

    public JPanel getHighlightSequenceJPanel() {
        return this.highlightSequenceJPanel;
    }

    public JTextField getHighlightValuesJTextField() {
        return this.highlightValuesJTextField;
    }

    public int getHighlightType() {
        return this.sequenceRadioButton.isSelected() ? 0 : 1;
    }

    public int getAboveEqualsOrBelow() {
        int aboveEqualsOrBelow = 0;
        if (this.equalsRadioButton.isSelected()) {
            aboveEqualsOrBelow = 1;
        }
        if (this.belowRadioButton.isSelected()) {
            aboveEqualsOrBelow = 2;
        }
        return aboveEqualsOrBelow;
    }

    public double getHighlightThreshold() {
        String threshold = this.highlightValuesJTextField.getText();
        try {
            return Double.parseDouble(threshold);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

