/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.presenter.ProfileGridPresenter;

public class ExportJPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 8154981749436394738L;
    private JLabel columnsPerTierLabel = new JLabel("Columns:");
    private JLabel formatLabel = new JLabel("Format:");
    private JButton outputFileBrowseButton = new JButton("Browse");
    private JTextField columnsPerTierBlank = new JTextField(String.valueOf(100), 4);
    private JTextField outputFileBlank = new JTextField(1);
    private JButton exportButton = new JButton("Export");
    private JLabel rangeJLabel = new JLabel("  Range:");
    private JTextField startOfRange = new JTextField("1", 4);
    private JTextField endOfRange = new JTextField(4);
    private JLabel toLabel = new JLabel("to");
    private JComboBox fileTypeSelection = new JComboBox<String>(new String[]{"Excel", "FASTA", "PNG", "PyMOL"});
    private JComboBox profileGridJComboBox = new JComboBox<String>(new String[]{"Top", "Bottom"});
    private JPanel columnsSelectionPanel = new JPanel();
    private ProfileGridPresenter profileGridPresenter;
    private JLabel profileGridJLabel = new JLabel("ProfileGrid: ");
    private String pdbFile = null;

    public ExportJPanel(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
    }

    public void initializeExportPanel() {
        LineBorder border = new LineBorder(new Color(9, 0, 128), 1);
        TitledBorder exportPanelBorder = BorderFactory.createTitledBorder(border, "Export");
        exportPanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(exportPanelBorder);
        GridBagLayout exportPanelLayout = new GridBagLayout();
        GridBagConstraints exportPanelConstraints = new GridBagConstraints();
        this.setLayout(exportPanelLayout);
        exportPanelConstraints.fill = 2;
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 0;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 1;
        this.outputFileBrowseButton.addActionListener(this);
        this.add((Component)this.outputFileBrowseButton, exportPanelConstraints);
        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.weightx = 1.0;
        exportPanelConstraints.gridwidth = 2;
        this.add((Component)this.outputFileBlank, exportPanelConstraints);
        exportPanelConstraints.fill = 0;
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0.0;
        exportPanelConstraints.gridwidth = 1;
        this.add((Component)this.formatLabel, exportPanelConstraints);
        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.weightx = 1.0;
        exportPanelConstraints.anchor = 21;
        this.add((Component)this.fileTypeSelection, exportPanelConstraints);
        this.columnsSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints columnSelectionConstraints = new GridBagConstraints();
        columnSelectionConstraints.weightx = 0.0;
        columnSelectionConstraints.weighty = 0.0;
        columnSelectionConstraints.gridx = 0;
        columnSelectionConstraints.gridy = 0;
        columnSelectionConstraints.fill = 1;
        columnSelectionConstraints.anchor = 21;
        columnSelectionConstraints.gridwidth = 1;
        columnSelectionConstraints.gridheight = 1;
        this.columnsSelectionPanel.add((Component)this.rangeJLabel, columnSelectionConstraints);
        this.startOfRange.setText(String.valueOf(1));
        ++columnSelectionConstraints.gridx;
        columnSelectionConstraints.weightx = 1.0;
        this.columnsSelectionPanel.add((Component)this.startOfRange, columnSelectionConstraints);
        ++columnSelectionConstraints.gridx;
        this.columnsSelectionPanel.add((Component)this.toLabel, columnSelectionConstraints);
        ++columnSelectionConstraints.gridx;
        this.columnsSelectionPanel.add((Component)this.endOfRange, columnSelectionConstraints);
        JPanel thirdExportRowJPanel = new JPanel(new GridBagLayout());
        GridBagConstraints thirdExportRowConstraints = new GridBagConstraints();
        exportPanelConstraints.gridx = 2;
        this.add((Component)this.columnsSelectionPanel, exportPanelConstraints);
        thirdExportRowConstraints.gridx = 0;
        thirdExportRowConstraints.gridy = 0;
        thirdExportRowConstraints.fill = 0;
        thirdExportRowJPanel.add((Component)this.columnsPerTierLabel, thirdExportRowConstraints);
        this.columnsPerTierLabel.setEnabled(false);
        ++thirdExportRowConstraints.gridx;
        thirdExportRowJPanel.add((Component)this.columnsPerTierBlank, thirdExportRowConstraints);
        this.columnsPerTierBlank.setEnabled(false);
        this.columnsPerTierBlank.addKeyListener(this);
        ++thirdExportRowConstraints.gridx;
        thirdExportRowJPanel.add((Component)this.profileGridJLabel, thirdExportRowConstraints);
        this.profileGridJLabel.setEnabled(false);
        ++thirdExportRowConstraints.gridx;
        thirdExportRowJPanel.add((Component)this.profileGridJComboBox, thirdExportRowConstraints);
        this.profileGridJComboBox.setEnabled(false);
        ++thirdExportRowConstraints.gridx;
        thirdExportRowJPanel.add((Component)this.exportButton, thirdExportRowConstraints);
        columnSelectionConstraints.gridx = 0;
        columnSelectionConstraints.gridy = 2;
        columnSelectionConstraints.gridwidth = 3;
        columnSelectionConstraints.gridheight = 2;
        this.add((Component)thirdExportRowJPanel, columnSelectionConstraints);
        this.exportButton.addActionListener(this);
        this.exportButton.setEnabled(false);
        ProfileGridPresenter.setAllComponentsEnabled(false, this.columnsSelectionPanel);
        this.fileTypeSelection.addActionListener(this);
    }

    public int getColumnsPerTier() {
        try {
            return Integer.parseInt(this.columnsPerTierBlank.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getFirstColumn() {
        try {
            return Integer.parseInt(this.startOfRange.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setStartColumn(int nStartColumn) {
        this.startOfRange.setText(String.valueOf(nStartColumn));
    }

    public void setFinalColumn(int nFinalColumn) {
        this.endOfRange.setText(String.valueOf(nFinalColumn));
    }

    public int getLastColumn() {
        try {
            return Integer.parseInt(this.endOfRange.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getOutputFilename() {
        return this.outputFileBlank.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            int fileType = this.fileTypeSelection.getSelectedIndex();
            switch (fileType) {
                case 0: {
                    this.profileGridPresenter.outputExcelFile();
                    break;
                }
                case 1: {
                    this.profileGridPresenter.outputFASTAFile();
                    break;
                }
                case 2: {
                    this.profileGridPresenter.outputImageFile();
                    break;
                }
                case 3: {
                    this.profileGridPresenter.outputPyMOLScript();
                }
            }
        }
        if (e.getSource() == this.outputFileBrowseButton) {
            this.profileGridPresenter.showSelectOutputFileDialog();
        }
        if (e.getSource() == this.fileTypeSelection) {
            if (this.fileTypeSelection.getSelectedIndex() == 0) {
                this.outputFileBlank.setText(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3) + "xls");
                this.rangeJLabel.setEnabled(true);
                this.toLabel.setEnabled(true);
                this.startOfRange.setEnabled(true);
                this.endOfRange.setEnabled(true);
                this.columnsPerTierLabel.setEnabled(true);
                this.columnsPerTierBlank.setEnabled(true);
            }
            if (this.fileTypeSelection.getSelectedIndex() == 1) {
                this.outputFileBlank.setText(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3) + "afa");
                this.columnsPerTierLabel.setEnabled(false);
                this.columnsPerTierBlank.setEnabled(false);
                this.rangeJLabel.setEnabled(false);
                this.toLabel.setEnabled(false);
                this.startOfRange.setEnabled(false);
                this.endOfRange.setEnabled(false);
            }
            if (this.fileTypeSelection.getSelectedIndex() == 2) {
                this.outputFileBlank.setText(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3) + "png");
                this.columnsPerTierLabel.setEnabled(false);
                this.columnsPerTierBlank.setEnabled(false);
                this.rangeJLabel.setEnabled(false);
                this.toLabel.setEnabled(false);
                this.startOfRange.setEnabled(false);
                this.endOfRange.setEnabled(false);
            }
            if (this.fileTypeSelection.getSelectedIndex() == 3) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Please select PDB file");
                int fileSelected = jFileChooser.showDialog(this, "Select");
                if (fileSelected == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    try {
                        this.pdbFile = file.getCanonicalPath();
                    }
                    catch (IOException ioException) {
                        // empty catch block
                    }
                }
                this.outputFileBlank.setText(this.outputFileBlank.getText().substring(0, this.outputFileBlank.getText().length() - 3) + "pml");
                this.columnsPerTierLabel.setEnabled(false);
                this.columnsPerTierBlank.setEnabled(false);
            }
        }
    }

    public void setOutputFileType(int index) {
        this.fileTypeSelection.setSelectedIndex(index);
    }

    public JPanel getColumnsSelectionPanel() {
        return this.columnsSelectionPanel;
    }

    public void setOutputFilename(String nFilename) {
        this.outputFileBlank.setText(nFilename);
    }

    public void setDualDisplayEnabled(boolean enabled) {
        this.profileGridJLabel.setEnabled(enabled);
        this.profileGridJComboBox.setEnabled(enabled);
        if (!enabled) {
            this.profileGridJComboBox.setSelectedIndex(0);
        }
    }

    public int getSelectedProfileGrid() {
        return this.profileGridJComboBox.getSelectedIndex();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.columnsPerTierBlank) {
            try {
                int numColumns = Integer.parseInt(this.columnsPerTierBlank.getText());
                if (numColumns > 0) {
                    this.profileGridPresenter.updateTopProfileGrid();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.columnsPerTierLabel.setEnabled(enabled);
        this.columnsPerTierBlank.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public JTextField getOutputFileBlank() {
        return this.outputFileBlank;
    }

    public String getPDBFile() {
        return this.pdbFile;
    }
}

