/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jprofilegrid.presenter.ProfileGridPresenter;

public class FiltersJPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4146127699838314762L;
    private JTextField speciesNameFilter = new JTextField(String.valueOf(""));
    private JTextField sequenceFilter = new JTextField(String.valueOf(""));
    private JLabel[] parameterLabels = new JLabel[]{new JLabel("Sequence Name:"), new JLabel("Sequence:")};
    private JComponent[] parameterBlanks = new JComponent[]{this.speciesNameFilter, this.sequenceFilter};
    private String applyFilterButtonlabel = new String("Filter");
    private String optionsPanelTitle = new String("Regular Expression Filters");
    private JButton applyFilterButton = new JButton(this.applyFilterButtonlabel);
    private JLabel matches = new JLabel("No Matches");
    private JLabel filtersLabel = new JLabel("Regular Expression Filters: ");
    private JCheckBox filtersCheckBox = new JCheckBox();
    private ProfileGridPresenter profileGridPresenter;

    public FiltersJPanel(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyFilterButton) {
            this.profileGridPresenter.onRegExFiltersChanged(this.speciesNameFilter.getText(), this.sequenceFilter.getText());
        }
        if (e.getSource() == this.filtersCheckBox) {
            this.profileGridPresenter.onFilterchange();
            for (int i = 0; i < this.parameterLabels.length; ++i) {
                this.parameterLabels[i].setEnabled(this.filtersCheckBox.isSelected());
                this.parameterBlanks[i].setEnabled(this.filtersCheckBox.isSelected());
                this.applyFilterButton.setEnabled(this.filtersCheckBox.isSelected());
                this.matches.setEnabled(this.filtersCheckBox.isSelected());
            }
        }
    }

    public void initializeParametersPanel() {
        this.setLayout(new GridBagLayout());
        LineBorder border = new LineBorder(new Color(72, 61, 139), 1);
        TitledBorder optionsPanelBorder = BorderFactory.createTitledBorder(border, this.optionsPanelTitle);
        optionsPanelBorder.setTitleColor(new Color(0, 0, 0));
        this.setBorder(optionsPanelBorder);
        GridBagConstraints constraints = new GridBagConstraints();
        this.sequenceFilter.setAlignmentX(1.0f);
        this.setAlignmentX(1.0f);
        this.applyFilterButton.addActionListener(this);
        this.applyFilterButton.setEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 22;
        constraints.gridwidth = 2;
        this.add((Component)this.filtersLabel, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 2;
        constraints.anchor = 21;
        this.add((Component)this.filtersCheckBox, constraints);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        constraints.anchor = 10;
        this.add((Component)this.matches, constraints);
        this.matches.setBackground(this.getBackground());
        this.matches.setVisible(false);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.filtersCheckBox.setSelected(true);
        this.filtersCheckBox.addActionListener(this);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        this.add((Component)this.parameterLabels[0], constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.gridwidth = 3;
        this.add((Component)this.parameterBlanks[0], constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        this.add((Component)this.parameterLabels[1], constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.gridwidth = 3;
        this.add((Component)this.parameterBlanks[1], constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 4;
        constraints.weightx = 0.0;
        constraints.gridy = 1;
        constraints.gridheight = 2;
        this.add((Component)this.applyFilterButton, constraints);
    }

    public void enableProfileGridButton() {
        this.applyFilterButton.setEnabled(true);
    }

    public void disableProfileGridButton() {
        this.applyFilterButton.setEnabled(false);
    }

    public boolean getRegExFilteringEnabled() {
        return this.filtersCheckBox.isSelected();
    }
}

