/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.gridparameters.GridParametersJPanel;
import jprofilegrid.view.main.ExportJPanel;
import jprofilegrid.view.main.FiltersJPanel;
import jprofilegrid.view.main.LoadAlignmentJPanel;
import jprofilegrid.view.main.SimilarityParametersJPanel;

public class MainJFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -2882870135254599572L;
    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private LoadAlignmentJPanel loadAlignmentJPanel;
    private GridParametersJPanel gridParametersJPanel;
    private FiltersJPanel filtersJPanel;
    private SimilarityParametersJPanel similarityParametersJPanel;
    private ExportJPanel exportJPanel;

    public MainJFrame(ProfileGridPresenter profileGridPresenter) {
        super("JProfileGrid");
        this.loadAlignmentJPanel = new LoadAlignmentJPanel(profileGridPresenter);
        this.gridParametersJPanel = new GridParametersJPanel(profileGridPresenter);
        this.filtersJPanel = new FiltersJPanel(profileGridPresenter);
        this.similarityParametersJPanel = new SimilarityParametersJPanel(profileGridPresenter);
        this.exportJPanel = new ExportJPanel(profileGridPresenter);
        this.setMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.addWindowListener(this.openWindowsMenu);
        this.menuBar.add(this.openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.displayWindow();
        this.pack();
    }

    public void displayWindow() {
        this.initializeConstantValues();
        this.initializeJPanels();
        this.pack();
        this.setVisible(true);
    }

    private void initializeConstantValues() {
        this.setLocation(25, 25);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
    }

    private void initializeJPanels() {
        this.loadAlignmentJPanel.initializeLoadMSAPanel();
        this.filtersJPanel.initializeParametersPanel();
        this.similarityParametersJPanel.initializeParametersPanel();
        this.exportJPanel.initializeExportPanel();
        this.gridParametersJPanel.initializeAnalyzePanel();
        ProfileGridPresenter.setAllComponentsEnabled(false, this.similarityParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, this.gridParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, this.gridParametersJPanel.getPositionRulerJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, this.gridParametersJPanel.getFrequencyColorsJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, this.gridParametersJPanel.getSortAndDualDisplayJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, this.gridParametersJPanel.getOverviewTypesJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, this.filtersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, this.exportJPanel);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.setLayout(this.layout);
        this.add((Component)this.loadAlignmentJPanel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.gridParametersJPanel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.filtersJPanel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.similarityParametersJPanel, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.exportJPanel, this.constraints);
    }

    public LoadAlignmentJPanel getLoadAlignmentPanel() {
        return this.loadAlignmentJPanel;
    }

    public SimilarityParametersJPanel getSimilarityParametersPanel() {
        return this.similarityParametersJPanel;
    }

    public GridParametersJPanel getGridParametersPanel() {
        return this.gridParametersJPanel;
    }

    public ExportJPanel getExportPanel() {
        return this.exportJPanel;
    }

    public FiltersJPanel getFiltersPanel() {
        return this.filtersJPanel;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (event.getSource() == this.aboutMenuItem) {
            this.showAboutDialog();
        }
    }

    public void showAboutDialog() {
        JPanel aboutJPanel = new JPanel();
        aboutJPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);
        constraints.insets = new Insets(0, 10, 2, 10);
        JLabel rowOne = new JLabel("JProfileGrid v2.0.5; January 17th, 2013");
        rowOne.setHorizontalAlignment(0);
        JLabel rowTwo = new JLabel("http://www.ProfileGrid.org");
        rowTwo.setHorizontalAlignment(0);
        JTextArea rowThree = new JTextArea("Cite publication: A.I.Roca, A.C.Abajian, D.J.Vigerust. ProfileGrids solve the\nlarge alignment visualization problem: influenza hemeagglutinin example.\nF1000Research 2:2 (2013)");
        rowThree.setBackground(this.getBackground());
        rowThree.setEditable(false);
        JTextArea rowFive = new JTextArea("The ProfileGrid representation is in the public domain if others\nwish to code their own implementations.");
        rowFive.setBackground(this.getBackground());
        rowFive.setFont(new Font(rowFive.getFont().getName(), 1, rowFive.getFont().getSize()));
        rowFive.setEditable(false);
        JTextArea rowSix = new JTextArea("Copyright (c) 2012 ProfileGrid.org\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program. If not, see http://www.gnu.org/licenses/.");
        rowSix.setBackground(this.getBackground());
        rowSix.setEditable(false);
        aboutJPanel.add((Component)rowOne, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 10, 10);
        aboutJPanel.add((Component)rowTwo, constraints);
        constraints.insets = new Insets(0, 10, 2, 10);
        ++constraints.gridy;
        constraints.anchor = 21;
        aboutJPanel.add((Component)rowThree, constraints);
        constraints.insets = new Insets(10, 10, 2, 10);
        ++constraints.gridy;
        aboutJPanel.add((Component)rowFive, constraints);
        ++constraints.gridy;
        aboutJPanel.add((Component)rowSix, constraints);
        aboutJPanel.setBackground(this.getBackground());
        JDialog aboutDialog = new JDialog((Frame)this, "About");
        aboutDialog.add(aboutJPanel);
        aboutDialog.pack();
        aboutDialog.setLocation(this.getX() + (this.getWidth() - aboutDialog.getWidth()) / 2, this.getY());
        aboutDialog.setResizable(false);
        aboutDialog.setVisible(true);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

