/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jprofilegrid.view.metadata.MetaDataType;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    private static final short META_DATA_TYPES_ROW = 0;
    private static final short SEQUENCE_NAMES_COLUMN = 0;
    private HashMap<String, MetaDataType> metaDataTypesByName = new HashMap();
    private HashMap<String, HashMap<String, String>> sequenceMetaData = new HashMap();

    public HashMap<String, String> getMetaDataForSequence(String sequenceName) {
        return this.sequenceMetaData.get(sequenceName);
    }

    public Collection<String> getMetaDataTypesByColumn() {
        return this.metaDataTypesByName.keySet();
    }

    public List<String> getMetaDataValuesOfType(String metaDataType) {
        if (metaDataType == null) {
            return null;
        }
        return this.metaDataTypesByName.get(metaDataType).getValues();
    }

    public List<String> getSequencesWithMetaDataTypeMatching(Object metaDataType, Object[] metaDataValues) {
        ArrayList<String> matchingSequences = new ArrayList<String>();
        if (metaDataType != null && metaDataValues != null) {
            for (String sequence : this.sequenceMetaData.keySet()) {
                HashMap<String, String> metaData = this.sequenceMetaData.get(sequence);
                String value = metaData.get(metaDataType);
                for (Object metaDataValue : metaDataValues) {
                    if (!metaDataValue.equals(value)) continue;
                    matchingSequences.add(sequence);
                }
            }
        }
        return matchingSequences;
    }

    public MetaData(String metaDataFilename) throws BiffException, IOException {
        if (metaDataFilename == null || metaDataFilename.isEmpty()) {
            return;
        }
        File metaDataFile = new File(metaDataFilename);
        Workbook metaDataWorkbook = null;
        metaDataWorkbook = Workbook.getWorkbook(metaDataFile);
        if (metaDataWorkbook != null && metaDataWorkbook.getNumberOfSheets() > 0) {
            Sheet metaDataSheet = metaDataWorkbook.getSheet(0);
            int rows = metaDataSheet.getRows();
            int cols = metaDataSheet.getColumns();
            ArrayList<String> sequenceNamesByRow = new ArrayList<String>();
            ArrayList<String> metaDataTypesByColumn = new ArrayList<String>();
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    String content;
                    Cell cell = metaDataSheet.getCell(col, row);
                    if (cell == null || (content = cell.getContents()) == null || content.isEmpty()) continue;
                    if (row == 0) {
                        metaDataTypesByColumn.add(content);
                        this.metaDataTypesByName.put(content, new MetaDataType());
                        continue;
                    }
                    if (col == 0) {
                        sequenceNamesByRow.add(content);
                        this.sequenceMetaData.put(content, new HashMap());
                    }
                    String metaDataType = (String)metaDataTypesByColumn.get(col);
                    String sequenceName = (String)sequenceNamesByRow.get(row - 1);
                    this.metaDataTypesByName.get(metaDataType).addValue(content);
                    this.sequenceMetaData.get(sequenceName).put(metaDataType, content);
                }
            }
        }
    }
}

