/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.metadata;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.metadata.ColumnJScrollPane;
import jprofilegrid.view.metadata.MetaData;
import jprofilegrid.view.metadata.MetaDataValue;

public class MetaDataColumnJPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JList metaDataTypesJList = new JList();
    private JList metaDataValuesJList = new JList();
    private JList matchingSequencesJList = new JList();
    private MetaData metaData;
    private ProfileGridPresenter profileGridPresenter;

    public MetaDataColumnJPanel(ProfileGridPresenter profileGridPresenter, String label, MetaData metaData) {
        this.profileGridPresenter = profileGridPresenter;
        this.metaData = metaData;
        Collection<String> metaDataTypes = metaData.getMetaDataTypesByColumn();
        this.metaDataTypesJList.setModel(new CollectionListModel(metaDataTypes));
        this.setupLayout();
        this.metaDataTypesJList.addListSelectionListener(this);
        this.metaDataTypesJList.setSelectionMode(0);
        this.metaDataValuesJList.addListSelectionListener(this);
        this.metaDataValuesJList.setSelectionMode(2);
        this.matchingSequencesJList.setEnabled(false);
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)new Label("Choose Meta Data Type"), gbc);
        ++gbc.gridy;
        this.add((Component)new ColumnJScrollPane(this.metaDataTypesJList), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)new Label("Choose Meta Data Value"), gbc);
        ++gbc.gridy;
        this.add((Component)new ColumnJScrollPane(this.metaDataValuesJList), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)new Label("Matching Sequences"), gbc);
        ++gbc.gridy;
        this.add((Component)new ColumnJScrollPane(this.matchingSequencesJList), gbc);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object source = listSelectionEvent.getSource();
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (source == this.metaDataTypesJList) {
                List<String> metaDataTypeValues = this.metaData.getMetaDataValuesOfType((String)this.metaDataTypesJList.getSelectedValue());
                this.metaDataValuesJList.setModel(new CollectionListModel(metaDataTypeValues));
            }
            if (source == this.metaDataValuesJList) {
                List<String> matchingSequences = this.metaData.getSequencesWithMetaDataTypeMatching(this.metaDataTypesJList.getSelectedValue(), this.metaDataValuesJList.getSelectedValues());
                this.matchingSequencesJList.setModel(new CollectionListModel(matchingSequences));
                this.profileGridPresenter.onMetaDataFilterChanged(matchingSequences);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;

        public CollectionListModel(Collection<String> listData) {
            PriorityQueue<MetaDataValue> sorter = new PriorityQueue<MetaDataValue>();
            Iterator<String> dataIterator = listData.iterator();
            while (dataIterator.hasNext()) {
                sorter.add(new MetaDataValue(dataIterator.next()));
            }
            while (!sorter.isEmpty()) {
                this.addElement(((MetaDataValue)sorter.remove()).getSValue());
            }
        }
    }
}

