/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.metadata;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.metadata.MetaData;
import jprofilegrid.view.metadata.MetaDataColumnJPanel;

public class MetaDataColumnsJFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private List<JScrollPane> metaDataColumnJScrollPanes = new ArrayList<JScrollPane>();
    private ProfileGridPresenter profileGridPresenter;

    public MetaDataColumnsJFrame(ProfileGridPresenter profileGridPresenter) {
        super("Meta Data Columns");
        this.profileGridPresenter = profileGridPresenter;
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setupLayout();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
    }

    public void addMetaDataColumnJPanel(MetaDataColumnJPanel metaDataColumnJPanel) {
        this.metaDataColumnJScrollPanes.add(new JScrollPane(metaDataColumnJPanel));
        this.reloadMetaDataColumnJPanels();
    }

    public void removeAllColumns() {
        for (JScrollPane metaDataColumnJScrollPane : this.metaDataColumnJScrollPanes) {
            this.remove(metaDataColumnJScrollPane);
        }
        this.metaDataColumnJScrollPanes.clear();
    }

    private void reloadMetaDataColumnJPanels() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        for (JScrollPane metaDataColumnJScrollPane : this.metaDataColumnJScrollPanes) {
            this.add((Component)metaDataColumnJScrollPane, gbc);
            ++gbc.gridx;
        }
        this.pack();
    }

    public void showMetaDataFileSelectionDialog() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select Meta Data Excel File", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        String metaDataFilename = fileDialog.getDirectory() + fileDialog.getFile();
        this.loadMetaDataFromFile(metaDataFilename);
    }

    private void loadMetaDataFromFile(String metaDataFilename) {
        try {
            MetaData metaData = new MetaData(metaDataFilename);
            MetaDataColumnJPanel metaDataColumnJPanel = new MetaDataColumnJPanel(this.profileGridPresenter, "Choose Meta Data Column", metaData);
            this.removeAllColumns();
            this.addMetaDataColumnJPanel(metaDataColumnJPanel);
            this.setVisible(true);
        }
        catch (Exception e) {
            this.setVisible(false);
            JOptionPane.showMessageDialog(new JFrame(), "Invalid metadata file format.", "Invalid Metadata File", 0);
        }
    }
}

