/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.overview;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.overview.AlignmentOverviewTableCellRenderer;

public class AlignmentOverviewJPanel
extends JPanel {
    private static final long serialVersionUID = -6107154041665201540L;
    private TableModel tableModel;
    private JTable jtable;

    public AlignmentOverviewJPanel(ProfileGridPresenter profileGridPresenter) {
        this.tableModel = profileGridPresenter.constructAlignmentOverviewTableModel();
        this.setLayout(new GridLayout(1, 1));
        this.setOpaque(true);
    }

    public void resetDisplay() {
        this.removeAll();
        this.jtable = new JTable(this.tableModel);
        this.jtable.getTableHeader().setReorderingAllowed(false);
        this.jtable.setDragEnabled(false);
        this.jtable.setAutoResizeMode(4);
        this.jtable.setCellSelectionEnabled(false);
        int cols = this.tableModel.getColumnCount();
        this.jtable.setDefaultRenderer(Object.class, new AlignmentOverviewTableCellRenderer());
        this.jtable.setShowGrid(false);
        this.jtable.setRowHeight(1);
        this.jtable.setRowMargin(0);
        for (int i = 0; i < cols; ++i) {
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            tableColumnModel.setColumnMargin(0);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setMinWidth(1);
            tableColumn.setMaxWidth(1);
            tableColumn.setPreferredWidth(1);
            tableColumn.setWidth(1);
            tableColumn.setResizable(true);
        }
        this.add(this.jtable);
        this.repaint();
    }
}

