/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.overview.AlignmentOverviewJPanel;
import jprofilegrid.view.overview.OverviewJPanel;

public class OverviewJFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -8447430469987480465L;
    private AlignmentOverviewJPanel alignmentOverviewJPanel;
    private OverviewJPanel overviewJPanel = new OverviewJPanel();
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private ProfileGridPresenter profileGridPresenter;

    public OverviewJFrame(ProfileGridPresenter profileGridPresenter, String title) {
        super(title);
        this.profileGridPresenter = profileGridPresenter;
        this.alignmentOverviewJPanel = new AlignmentOverviewJPanel(profileGridPresenter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.overviewJPanel, "North");
        this.setDefaultCloseOperation(1);
        this.initializeMenuBar();
        this.pack();
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void resetDisplay(ProfileGrid profileGrid) {
        this.overviewJPanel.resetDisplay(profileGrid);
        this.alignmentOverviewJPanel.resetDisplay();
        this.pack();
    }

    public void displayProfileGridOverview(ProfileGrid profileGrid) {
        this.remove(this.alignmentOverviewJPanel);
        this.add((Component)this.overviewJPanel, "North");
        this.resetDisplay(profileGrid);
    }

    public void displayAlignmentOverview(int columnsPerTier, ProfileGrid profileGrid) {
        this.remove(this.overviewJPanel);
        this.add((Component)this.alignmentOverviewJPanel, "North");
        this.resetDisplay(profileGrid);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (event.getSource() == this.aboutMenuItem) {
            this.profileGridPresenter.showAboutDialog();
            return;
        }
    }
}

