/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.overview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.view.overview.GridLayout2;
import jprofilegrid.view.overview.ProfileGridTableCellRenderer;
import jprofilegrid.view.profilegrid.FixedAAColumnInTable;
import jprofilegrid.view.profilegrid.ProfileGridTableModel;

public class OverviewJPanel
extends JPanel {
    private static final long serialVersionUID = 8810051498829113732L;
    private ArrayList<ProfileGridTableModel> profileGridTableModels;
    private ArrayList<JTable> profileGridJTables;
    private JScrollPane jscrollPane;
    private JPanel nestedPanel = new JPanel();
    private ProfileGridTableModel symbolSideBarsData;

    public OverviewJPanel() {
        this.setLayout(new GridLayout2(0, 1));
        this.setOpaque(true);
    }

    public void resetDisplayedData(ProfileGrid profileGrid) {
        int sequenceColumnOffset = 0;
        this.nestedPanel.setLayout(new GridLayout2(this.profileGridJTables.size() + 1, 1));
        for (int i = 0; i < this.profileGridJTables.size(); ++i) {
            int j;
            ProfileGridTableModel profileGridTableModel = this.profileGridTableModels.get(i);
            JTable profileGridJTable = this.profileGridJTables.get(i);
            int columnCount = profileGridTableModel.getColumnCount();
            AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
            int numberOfRows = analysisOptions.alignmentConstants.getNames().length;
            Cell[][] aminoAcidCounts = profileGrid.getEntireAlignment().getAminoAcidCounts();
            for (j = 0; j < columnCount; ++j) {
                for (int k = 0; k < numberOfRows; ++k) {
                    profileGridTableModel.setValueAt(aminoAcidCounts[sequenceColumnOffset][k], k, j);
                }
                ++sequenceColumnOffset;
            }
            for (j = 0; j < profileGridJTable.getColumnCount(); ++j) {
                profileGridJTable.getColumnModel().getColumn(j).setMinWidth(5);
                profileGridJTable.getColumnModel().getColumn(j).setMaxWidth(5);
                profileGridJTable.getColumnModel().getColumn(j).setPreferredWidth(5);
            }
            profileGridJTable.setRowHeight(5);
        }
        this.repaint();
    }

    public void resetDisplay(ProfileGrid profileGrid) {
        int numColumns = profileGrid.getAnalysisOptions().columnsPerTier;
        this.nestedPanel.removeAll();
        int totalNumberOfAminoAcids = profileGrid.getEntireAlignment().getAminoAcidCounts().length;
        int numRows = (int)Math.ceil((double)totalNumberOfAminoAcids / (double)numColumns);
        int leftOverColumns = totalNumberOfAminoAcids - numColumns * (numRows - 1);
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        int numAminoAcids = analysisOptions.alignmentConstants.getNames().length;
        this.profileGridTableModels = new ArrayList();
        this.profileGridJTables = new ArrayList();
        for (int i = 0; i < numRows; ++i) {
            int numColumnsInRow = numColumns;
            if (i == numRows - 1 && leftOverColumns > 0) {
                numColumnsInRow = leftOverColumns;
            }
            ProfileGridTableModel profileGridTableModel = new ProfileGridTableModel(numAminoAcids, numColumnsInRow);
            this.profileGridTableModels.add(profileGridTableModel);
            JTable profileGridJTable = new JTable(profileGridTableModel);
            profileGridJTable.getTableHeader().setReorderingAllowed(false);
            profileGridJTable.setDragEnabled(false);
            profileGridJTable.setGridColor(Color.LIGHT_GRAY);
            profileGridJTable.setAutoResizeMode(0);
            profileGridJTable.setCellSelectionEnabled(false);
            profileGridJTable.setDefaultRenderer(Cell.class, new ProfileGridTableCellRenderer());
            profileGridJTable.setShowGrid(false);
            this.profileGridJTables.add(profileGridJTable);
            String[] aas = profileGrid.getSortedAminoAcidSymbols();
            this.symbolSideBarsData = new ProfileGridTableModel(aas.length, 1);
            for (int j = 0; j < aas.length; ++j) {
                this.symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED, Format.BOLD), aas[j]), j, 0);
            }
            JTable symbolSideBarsJTable = new JTable(this.symbolSideBarsData);
            symbolSideBarsJTable.getTableHeader().setReorderingAllowed(false);
            symbolSideBarsJTable.setColumnSelectionAllowed(false);
            symbolSideBarsJTable.setRowSelectionAllowed(false);
            symbolSideBarsJTable.setCellSelectionEnabled(false);
            symbolSideBarsJTable.setSize(5, 105);
            symbolSideBarsJTable.setPreferredSize(new Dimension(5, 105));
            symbolSideBarsJTable.setRowMargin(0);
            symbolSideBarsJTable.setRowHeight(5);
            int sortType = analysisOptions.sortType;
            String sortTypeName = analysisOptions.alignmentConstants.getSortTypes()[sortType];
            symbolSideBarsJTable.setDefaultRenderer(Text.class, new FixedAAColumnInTable(sortTypeName.equalsIgnoreCase("Taylor"), false));
            TableColumnModel symbolSideBarsTableColumnModel = symbolSideBarsJTable.getColumnModel();
            symbolSideBarsTableColumnModel.setColumnMargin(0);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new FlowLayout());
            jpanel.add(symbolSideBarsJTable);
            jpanel.add(profileGridJTable);
            this.nestedPanel.add(jpanel);
            JSeparator separator = new JSeparator(1);
            separator.setPreferredSize(new Dimension(1, separator.getPreferredSize().width));
            this.nestedPanel.add(separator);
        }
        if (this.jscrollPane != null) {
            this.remove(this.jscrollPane);
        }
        this.jscrollPane = new JScrollPane(this.nestedPanel);
        this.add(this.jscrollPane);
        this.resetDisplayedData(profileGrid);
    }

    public JScrollPane getScrollPanel() {
        return this.jscrollPane;
    }
}

