/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.profilegrid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.profilegrid.ProfileGridJPanel;

public class ProfileGridJFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 2296482860188831605L;
    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");
    private Menu aboutMenu = new Menu("About");
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
    private MenuItem quitMenuItem = new MenuItem("Quit");
    private ProfileGridJPanel topProfileGridJPanel;
    private ProfileGridJPanel bottomProfileGridJPanel;
    private DualDisplaySubJPanel dualDisplaySubJPanel = new DualDisplaySubJPanel();
    private boolean dualDisplayEnabled = false;
    boolean overviewJFrameVisible = false;
    private ProfileGridPresenter profileGridPresenter;

    public ProfileGridJFrame(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
        this.topProfileGridJPanel = new ProfileGridJPanel(profileGridPresenter);
        this.bottomProfileGridJPanel = new ProfileGridJPanel(profileGridPresenter);
        this.topProfileGridJPanel.setDualDisplay(this.bottomProfileGridJPanel);
        this.bottomProfileGridJPanel.setDualDisplay(this.topProfileGridJPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.topProfileGridJPanel, "North");
        this.add((Component)this.dualDisplaySubJPanel, "South");
        this.initializeMenuBar();
        this.setDefaultCloseOperation(1);
    }

    private void initializeMenuBar() {
        this.menuBar.add(this.fileMenu);
        OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
        this.addWindowListener(openWindowsMenu);
        this.menuBar.add(openWindowsMenu);
        this.menuBar.add(this.aboutMenu);
        this.quitMenuItem.addActionListener(this);
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.quitMenuItem);
        this.setMenuBar(this.menuBar);
    }

    public void setDualDisplay(boolean ddEnabled) {
        this.dualDisplayEnabled = ddEnabled;
        if (this.dualDisplayEnabled) {
            this.remove(this.topProfileGridJPanel);
            this.remove(this.bottomProfileGridJPanel);
            this.remove(this.dualDisplaySubJPanel);
            this.add((Component)this.topProfileGridJPanel, "North");
            this.bottomProfileGridJPanel.setIsInFocus(false);
            this.add((Component)this.bottomProfileGridJPanel, "Center");
        } else {
            this.remove(this.topProfileGridJPanel);
            this.remove(this.bottomProfileGridJPanel);
            this.remove(this.dualDisplaySubJPanel);
            this.add((Component)this.topProfileGridJPanel, "North");
        }
        this.add((Component)this.dualDisplaySubJPanel, "South");
    }

    public void resetTopProfileGrid(String title, ProfileGrid topProfileGrid) {
        this.setTitle(title);
        this.topProfileGridJPanel.setProfileGrid(topProfileGrid);
        this.pack();
    }

    public void resetBottomProfileGrid(ProfileGrid bottomProfileGrid) {
        this.bottomProfileGridJPanel.setProfileGrid(bottomProfileGrid);
        this.pack();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        if (event.getSource() == this.aboutMenuItem) {
            this.profileGridPresenter.showAboutDialog();
            return;
        }
    }

    private void enableLockedScrolling() {
        this.topProfileGridJPanel.setScrollLock(true);
        this.bottomProfileGridJPanel.setScrollLock(true);
    }

    private void disableLockedScrolling() {
        this.topProfileGridJPanel.setScrollLock(false);
        this.bottomProfileGridJPanel.setScrollLock(false);
    }

    public void loadHorizontalScrollPositions() {
        this.topProfileGridJPanel.saveHorizontalScrollPosition();
        if (this.dualDisplayEnabled) {
            this.bottomProfileGridJPanel.saveHorizontalScrollPosition();
        }
    }

    public void saveHorizontalScrollPositions() {
        this.topProfileGridJPanel.loadHorizontalScrollPosition();
        if (this.dualDisplayEnabled) {
            this.bottomProfileGridJPanel.loadHorizontalScrollPosition();
        }
    }

    public boolean getTopGridIsActive() {
        return this.dualDisplaySubJPanel.getTopGridIsActive();
    }

    public boolean getDualDisplayEnabled() {
        return this.dualDisplayEnabled;
    }

    public boolean getSelectionModeEnabled() {
        return this.dualDisplaySubJPanel.getSelectionModeEnabled();
    }

    public int getTopProfileGridSelectedRow() {
        return this.topProfileGridJPanel.getSelectedRow();
    }

    public int getTopProfileGridSelectedColumn() {
        return this.topProfileGridJPanel.getSelectedColumn();
    }

    private class DualDisplaySubJPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -2281446840864021327L;
        private JLabel dualDisplayModeJLabel = new JLabel("Dual Display Mode:");
        private JComboBox dualDisplayModesJComboBox = new JComboBox<String>(new String[]{"Single Display", "Pseudo Mirror", "Selection"});
        private JLabel lockScrollJLabel = new JLabel("Lock Horizontal Scroll:");
        private JCheckBox toggleLockScrollJCheckBox = new JCheckBox();

        public DualDisplaySubJPanel() {
            this.add(this.dualDisplayModeJLabel);
            this.dualDisplayModesJComboBox.addActionListener(this);
            this.add(this.dualDisplayModesJComboBox);
            this.add(this.lockScrollJLabel);
            this.toggleLockScrollJCheckBox.addActionListener(this);
            this.add(this.toggleLockScrollJCheckBox);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.toggleLockScrollJCheckBox) {
                if (this.toggleLockScrollJCheckBox.isSelected()) {
                    ProfileGridJFrame.this.enableLockedScrolling();
                } else {
                    ProfileGridJFrame.this.disableLockedScrolling();
                }
            }
            if (e.getSource() == this.dualDisplayModesJComboBox) {
                ProfileGridJFrame.this.profileGridPresenter.setDualDisplayMode(this.dualDisplayModesJComboBox.getSelectedIndex());
            }
        }

        public boolean getTopGridIsActive() {
            return true;
        }

        public boolean getSelectionModeEnabled() {
            return this.dualDisplayModesJComboBox.getSelectedIndex() == 2;
        }
    }
}

