/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.profilegrid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jprofilegrid.calculations.ResidueFrequencyCount;
import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Cell;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.model.Format;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.model.Tier;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.profilegrid.FixedAAColumnInTable;
import jprofilegrid.view.profilegrid.ProfileGridTableCellRenderer;
import jprofilegrid.view.profilegrid.ProfileGridTableModel;
import jxl.format.RGB;

public class ProfileGridJPanel
extends JPanel
implements AdjustmentListener,
ListSelectionListener {
    private static final long serialVersionUID = 8810051498829113732L;
    private ProfileGridTableModel profileGridTableModel;
    private JTable profileGridJTable;
    private ProfileGridTableModel symbolSideBarTableModel;
    public JTable symbolSideBarsJTable;
    private ProfileGridScrollPane jscrollPane;
    private boolean scrollLockEnabled = false;
    private boolean isInFocus = false;
    private int horizontalScrollValue = 0;
    private Border unselectedBorder;
    private Border selectedBorder;
    private ProfileGrid profileGrid;
    private ProfileGridPresenter profileGridPresenter;
    private ProfileGridJPanel dualDisplay;
    private int previousRow;
    private int previousCol;

    public ProfileGridJPanel(ProfileGridPresenter profileGridPresenter) {
        this.profileGridPresenter = profileGridPresenter;
        this.setLayout(new BorderLayout());
        this.selectedBorder = BorderFactory.createLineBorder(Color.RED);
        this.unselectedBorder = BorderFactory.createLineBorder(Color.WHITE);
        this.setOpaque(true);
    }

    public void setDualDisplay(ProfileGridJPanel dualDisplay) {
        this.dualDisplay = dualDisplay;
    }

    public void setProfileGrid(ProfileGrid profileGrid) {
        this.profileGrid = profileGrid;
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        int showValuesAs = analysisOptions.showValuesAs;
        AlignmentConstants alignmentConstants = analysisOptions.alignmentConstants;
        String[] symbolNames = alignmentConstants.getNames();
        int numSymbols = symbolNames.length + 4;
        this.profileGridTableModel = new ProfileGridTableModel(numSymbols, profileGrid.getSequenceLength());
        this.symbolSideBarTableModel = new ProfileGridTableModel(numSymbols, 2);
        this.profileGridJTable = new JTable(this.profileGridTableModel);
        this.symbolSideBarsJTable = new JTable(this.symbolSideBarTableModel);
        this.profileGridJTable.setCellSelectionEnabled(true);
        this.profileGridJTable.setSelectionMode(0);
        this.profileGridJTable.getSelectionModel().addListSelectionListener(this);
        this.profileGridJTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.profileGridJTable.getTableHeader().setReorderingAllowed(false);
        this.profileGridJTable.setDragEnabled(false);
        this.profileGridJTable.setGridColor(Color.LIGHT_GRAY);
        this.profileGridJTable.setAutoResizeMode(0);
        this.profileGridJTable.setDefaultRenderer(Cell.class, new ProfileGridTableCellRenderer(showValuesAs));
        this.symbolSideBarsJTable.getTableHeader().setReorderingAllowed(false);
        this.symbolSideBarsJTable.setColumnSelectionAllowed(false);
        this.symbolSideBarsJTable.setRowSelectionAllowed(false);
        this.symbolSideBarsJTable.setCellSelectionEnabled(false);
        int preferredHeight = this.symbolSideBarsJTable.getPreferredScrollableViewportSize().height;
        this.symbolSideBarsJTable.setPreferredScrollableViewportSize(new Dimension(150, preferredHeight));
        int sortType = analysisOptions.sortType;
        String sortTypeName = analysisOptions.alignmentConstants.getSortTypes()[sortType];
        this.symbolSideBarsJTable.setDefaultRenderer(Text.class, new FixedAAColumnInTable(sortTypeName.equalsIgnoreCase("Taylor"), true));
        this.horizontalScrollValue = 0;
        if (this.jscrollPane != null) {
            this.saveHorizontalScrollPosition();
            this.remove(this.jscrollPane);
        }
        this.jscrollPane = new ProfileGridScrollPane(this.profileGridJTable, analysisOptions.conservationRange);
        this.jscrollPane.setRowHeaderView(this.symbolSideBarsJTable);
        this.add((Component)this.jscrollPane, "Center");
        if (this.isInFocus) {
            this.jscrollPane.setBorder(this.selectedBorder);
        } else {
            this.jscrollPane.setBorder(this.unselectedBorder);
        }
        this.loadHorizontalScrollPosition();
        this.jscrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.resetDisplayedData();
        this.setPreferredSize(new Dimension(this.jscrollPane.getPreferredSize().width + 225, 27 * this.profileGridJTable.getRowHeight() - 2));
    }

    public void resetDisplayedData() {
        String[] sortedNames = this.profileGrid.getSortedAminoAcidNames();
        String[] sortedSymbols = this.profileGrid.getSortedAminoAcidSymbols();
        for (int i = 0; i < this.symbolSideBarTableModel.getRowCount(); ++i) {
            for (int j = 0; j < this.symbolSideBarTableModel.getColumnCount(); ++j) {
                Format format = new Format(Format.CENTER_ALIGNED, Format.BOLD);
                Text text = new Text(format);
                if (j == 0) {
                    if (i >= 4) {
                        text.setValue(sortedNames[i - 4]);
                    } else if (i == 0) {
                        int selectedRow = this.profileGridJTable.getSelectedRow();
                        String value = "";
                        if (selectedRow >= 0) {
                            value = this.profileGridTableModel.getValueAt(selectedRow, this.profileGridJTable.getSelectedRow()).toString();
                        }
                        text.setValue(value);
                    }
                }
                if (j == 1) {
                    switch (i) {
                        case 0: {
                            text.setValue("Posn");
                            break;
                        }
                        case 1: {
                            text.setValue("Major");
                            break;
                        }
                        case 2: {
                            text = this.profileGrid.getReferenceSequenceName();
                            break;
                        }
                        case 3: {
                            text = this.profileGrid.getHighlightSequenceName();
                            break;
                        }
                        default: {
                            text.setValue(sortedSymbols[i - 4]);
                        }
                    }
                }
                this.symbolSideBarTableModel.setValueAt(text, i, j);
            }
        }
        this.symbolSideBarsJTable.setRowHeight(12);
        AnalysisOptions analysisOptions = this.profileGrid.getAnalysisOptions();
        int numberOfRows = analysisOptions.alignmentConstants.getNames().length + 4;
        Tier entireAlignment = this.profileGrid.getEntireAlignment();
        Text[] positionInAlignmentRow = entireAlignment.getPositionInAlignmentRow();
        Text[] majorAminoAcidRow = entireAlignment.getMajorAminoAcidRow();
        Text[] positionSequenceRow = entireAlignment.getReferenceSequenceRow();
        Text[] highlightSequenceRow = entireAlignment.getHighlightSequenceRow();
        Cell[][] aminoAcidCounts = entireAlignment.getAminoAcidCounts();
        for (int i = 0; i < this.profileGridTableModel.getColumnCount(); ++i) {
            this.profileGridJTable.getColumnModel().getColumn(i).setPreferredWidth(30);
            for (int j = 0; j < numberOfRows; ++j) {
                Cell cell;
                switch (j) {
                    case 0: {
                        cell = positionInAlignmentRow[i];
                        break;
                    }
                    case 1: {
                        cell = majorAminoAcidRow[i];
                        break;
                    }
                    case 2: {
                        cell = positionSequenceRow[i];
                        break;
                    }
                    case 3: {
                        cell = highlightSequenceRow[i];
                        break;
                    }
                    default: {
                        cell = aminoAcidCounts[i][j - 4];
                    }
                }
                this.profileGridTableModel.setValueAt(cell, j, i);
            }
        }
        this.profileGridJTable.setRowHeight(12);
        this.repaint();
    }

    public void setScrollLock(boolean enableOrDisable) {
        this.scrollLockEnabled = enableOrDisable;
    }

    public JScrollPane getScrollPanel() {
        return this.jscrollPane;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.scrollLockEnabled) {
            this.dualDisplay.getScrollPanel().getHorizontalScrollBar().setValue(this.jscrollPane.getHorizontalScrollBar().getValue());
            this.dualDisplay.getScrollPanel().getHorizontalScrollBar().setValue(this.jscrollPane.getHorizontalScrollBar().getValue());
        }
    }

    public void saveHorizontalScrollPosition() {
        this.horizontalScrollValue = this.jscrollPane.getHorizontalScrollBar().getValue();
    }

    public void loadHorizontalScrollPosition() {
        this.jscrollPane.getHorizontalScrollBar().setValue(this.horizontalScrollValue);
        this.jscrollPane.getHorizontalScrollBar().setValue(this.horizontalScrollValue);
    }

    public void setIsInFocus(boolean focus) {
        this.isInFocus = focus;
    }

    public Border getUnselectedBorder() {
        return this.unselectedBorder;
    }

    public void focusLost(FocusEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        int col = this.profileGridJTable.getSelectedColumn();
        int row = this.profileGridJTable.getSelectedRow() - 4;
        if (col != this.previousCol || row != this.previousRow) {
            this.previousCol = col;
            this.previousRow = row;
            if (row >= 0) {
                Tier entireAlignment = this.profileGrid.getEntireAlignment();
                AnalysisOptions analysisOptions = this.profileGrid.getAnalysisOptions();
                ResidueFrequencyCount rfc = analysisOptions.sortedData;
                int[][] aaCounts = rfc.getAminoAcidCounts();
                if (col < aaCounts.length && row < aaCounts[row].length) {
                    int count = aaCounts[col][row];
                    String positionInReferenceSequence = entireAlignment.getPositionInAlignmentRow()[col].getValue();
                    String positionInHighlightSequence = entireAlignment.getHighlightSequenceArray()[col].getValue();
                    for (int i = 0; i < 4; ++i) {
                        Format format = new Format(Format.CENTER_ALIGNED, Format.BOLD);
                        Text text = new Text(format);
                        switch (i) {
                            case 0: {
                                text.setValue(rfc.getSortedAminoAcidSymbols()[row]);
                                break;
                            }
                            case 1: {
                                text.setValue(Integer.toString(count));
                                break;
                            }
                            case 2: {
                                text.setValue(positionInReferenceSequence);
                                break;
                            }
                            case 3: {
                                text.setValue(positionInHighlightSequence);
                            }
                        }
                        this.symbolSideBarTableModel.setValueAt(text, i, 0);
                    }
                }
                this.profileGridPresenter.setSelectedAminoAcid();
                this.repaint();
            }
        }
    }

    public int getSelectedRow() {
        return this.profileGridJTable.getSelectedRow() - 4;
    }

    public int getSelectedColumn() {
        return this.profileGridJTable.getSelectedColumn();
    }

    private class ProfileGridScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 1L;
        ConservationRange conservationRange;

        public ProfileGridScrollPane(JTable data, ConservationRange nConservationRange) {
            super(data);
            this.conservationRange = nConservationRange;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g != null) {
                g.clearRect(0, ProfileGridJPanel.this.symbolSideBarsJTable.getHeight(), ProfileGridJPanel.this.symbolSideBarsJTable.getWidth(), this.getHeight());
                if (this.conservationRange.getNumberOfRanges() > 0) {
                    int rectWidth = ProfileGridJPanel.this.symbolSideBarsJTable.getWidth() / this.conservationRange.getNumberOfRanges();
                    for (int i = 0; i < this.conservationRange.getNumberOfRanges(); ++i) {
                        RGB currentColor = this.conservationRange.getColour(i).getDefaultRGB();
                        new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
                        g.setColor(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
                        g.fillRect(i * rectWidth, ProfileGridJPanel.this.symbolSideBarsJTable.getHeight() + 3, rectWidth, 20);
                    }
                }
            }
        }
    }
}

