/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.view.profilegrid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jprofilegrid.model.Cell;
import jprofilegrid.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.RGB;
import jxl.write.WritableCellFormat;

public class ProfileGridTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -686000339606310665L;
    Component cell;
    Object value;
    WritableCellFormat cellFormat;
    private static DecimalFormat decimalFormatter = new DecimalFormat();
    public static int BORDER_THICKNESS = 2;
    private int showValuesAs;

    public ProfileGridTableCellRenderer(int showValuesAs) {
        this.showValuesAs = showValuesAs;
    }

    private void setBold() {
        if (((Cell)this.value).getFormat().isBold()) {
            this.cell.setFont(new Font("Times New Roman", 1, 12));
        } else {
            this.cell.setFont(new Font("Times New Roman", 0, 12));
        }
    }

    private void setBorders() {
        if (this.cellFormat.hasBorders()) {
            MatteBorder top = null;
            MatteBorder bottom = null;
            MatteBorder left = null;
            MatteBorder right = null;
            block12: for (int i = 0; i < 4; ++i) {
                RGB rgb = null;
                switch (i) {
                    case 0: {
                        rgb = this.cellFormat.getBorderColour(Border.TOP).getDefaultRGB();
                        break;
                    }
                    case 1: {
                        rgb = this.cellFormat.getBorderColour(Border.BOTTOM).getDefaultRGB();
                        break;
                    }
                    case 2: {
                        rgb = this.cellFormat.getBorderColour(Border.LEFT).getDefaultRGB();
                        break;
                    }
                    case 3: {
                        rgb = this.cellFormat.getBorderColour(Border.RIGHT).getDefaultRGB();
                    }
                }
                int r = rgb.getRed();
                int g = rgb.getGreen();
                int b = rgb.getBlue();
                Color c = r == 255 && g == 255 && b == 255 ? this.cell.getBackground() : new Color(r, g, b);
                switch (i) {
                    case 0: {
                        top = BorderFactory.createMatteBorder(BORDER_THICKNESS, 0, 0, 0, c);
                        continue block12;
                    }
                    case 1: {
                        bottom = BorderFactory.createMatteBorder(0, 0, BORDER_THICKNESS, 0, c);
                        continue block12;
                    }
                    case 2: {
                        left = BorderFactory.createMatteBorder(0, BORDER_THICKNESS, 0, 0, c);
                        continue block12;
                    }
                    case 3: {
                        right = BorderFactory.createMatteBorder(0, 0, 0, BORDER_THICKNESS, c);
                    }
                }
            }
            CompoundBorder topAndBottom = new CompoundBorder(top, bottom);
            CompoundBorder leftAndRight = new CompoundBorder(left, right);
            CompoundBorder allBorders = new CompoundBorder(topAndBottom, leftAndRight);
            this.setBorder(allBorders);
        }
    }

    private void setAlignment() {
        if (this.cellFormat.getAlignment() == Alignment.CENTRE) {
            super.setHorizontalAlignment(0);
        }
        if (this.cellFormat.getAlignment() == Alignment.RIGHT) {
            this.setAlignmentY(4.0f);
        }
        if (this.cellFormat.getAlignment() == Alignment.LEFT) {
            this.setAlignmentY(2.0f);
        }
    }

    private void setBackgroundColor() {
        RGB rgbBackColor = this.cellFormat.getBackgroundColour().getDefaultRGB();
        Color backColor = new Color(rgbBackColor.getRed(), rgbBackColor.getGreen(), rgbBackColor.getBlue());
        this.cell.setBackground(backColor);
    }

    private void setForegroundColor() {
        RGB foreGroundColor = this.cellFormat.getFont().getColour().getDefaultRGB();
        Color foreColor = new Color(foreGroundColor.getRed(), foreGroundColor.getGreen(), foreGroundColor.getBlue());
        this.cell.setForeground(foreColor);
    }

    private void tryToSetTextAsNumber(Component cell, String text, int row) {
        this.setText(text);
        try {
            if (row == 0) {
                if (Integer.parseInt(text) % 10 == 0) {
                    cell.setBackground(Color.LIGHT_GRAY);
                }
                return;
            }
            if (this.showValuesAs == 0) {
                int number = (int)Double.parseDouble(text);
                this.setText(String.valueOf(number));
            }
            if (this.showValuesAs == 1) {
                Double number = Double.parseDouble(text);
                String formattedNumber = decimalFormatter.format(number);
                this.setText(String.valueOf(formattedNumber));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Cell excelCell = (Cell)value;
        String excelCellString = excelCell.toString();
        this.cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.value = value;
        this.cellFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(excelCell);
        this.setBackgroundColor();
        this.tryToSetTextAsNumber(this.cell, excelCellString, row);
        if (row != 0) {
            this.setText(excelCellString.equalsIgnoreCase("0.0") || excelCellString.equalsIgnoreCase("0") ? "" : this.getText());
        }
        this.setBold();
        this.setBorders();
        this.setAlignment();
        this.setForegroundColor();
        if (isSelected) {
            int r = this.getBackground().getRed();
            int g = this.getBackground().getGreen();
            int b = this.getBackground().getBlue();
            int reductionAmount = 200;
            int red = r > reductionAmount ? r - reductionAmount : 0;
            int green = g > reductionAmount ? g - reductionAmount : 0;
            int blue = b > reductionAmount ? b - reductionAmount : 0;
            Color shadedBackground = new Color(red, green, blue);
            this.cell.setBackground(shadedBackground);
        }
        return this.cell;
    }

    static {
        decimalFormatter.setMaximumFractionDigits(2);
        decimalFormatter.setMinimumFractionDigits(2);
        decimalFormatter.setMaximumIntegerDigits(1);
        decimalFormatter.setMinimumIntegerDigits(1);
    }
}

