/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Vector;
import jprofilegrid.constants.AminoAcidConstants;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Tier;
import jprofilegrid.model.UnknownSymbol;
import jprofilegrid.model.UnknownSymbolSpecies;
import jprofilegrid.writers.excel.DefaultFonts;
import jprofilegrid.writers.excel.ExcelCell;
import jprofilegrid.writers.excel.ExcelDataBlockWriter;
import jprofilegrid.writers.excel.ExcelNumericCell;
import jprofilegrid.writers.excel.ExcelTextCell;
import jprofilegrid.writers.excel.ProfileGridCellToExcelCellConverter;
import jprofilegrid.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelFileWriter {
    private WritableWorkbook workbook;
    private ProfileGrid profileGrid;
    private WritableSheet currentSheet;
    private ExcelTextCell[] aminoAcidConstantsNames;
    private ExcelNumericCell[][] aminoAcidConstants;
    private ExcelTextCell[] aminoAcidSymbols;
    private ExcelTextCell[] aminoAcidNames;
    private ExcelTextCell comparisonSequenceRowName;
    private ExcelTextCell highlightSequenceRowName;
    private ExcelDataBlockWriter dataWriter;
    private Tier tier;
    private int startCol;
    private int startRow;
    private static int AMINO_ACID_DATA_ROW_OFFSET = 4;
    private static int AMINO_ACID_DATA_COLUMN_OFFSET = 2;
    private static int AMINO_ACID_NAMES_COLUMN_OFFSET = 0;
    private static int AMINO_ACID_SYMBOLS_COLUMN_OFFSET = 1;
    private static ExcelTextCell POSITION_IN_ALIGNMENT = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), "Posn");
    private static int POSITION_IN_ALIGNMENT_ROW_OFFSET = 0;
    private static int POSITION_IN_ALIGNMENT_COLUMN_OFFSET = 1;
    private static ExcelTextCell MAJOR_ROW = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), "Major");
    private static int MAJOR_ROW_OFFSET = 1;
    private static int MAJOR_COLUMN_OFFSET = 1;
    private static int COMPARISON_SEQUENCE_ROW_OFFSET = 2;
    private static int COMPARISON_SEQUENCE_COLUMN_OFFSET = 1;
    private static int HIGHLIGHT_SEQUENCE_ROW_OFFSET = 3;
    private static int HIGHLIGHT_SEQUENCE_COLUMN_OFFSET = 1;
    private static int ROWS_PER_TIER = 28;
    private static DecimalFormat formatter = new DecimalFormat();

    public ExcelFileWriter(WritableWorkbook nWorkbook, ProfileGrid nProfileGrid) {
        this.workbook = nWorkbook;
        this.profileGrid = nProfileGrid;
        this.setAminoAcidSymbols();
        this.setAminoAcidNames();
        this.setAminoAcidConstants();
        this.comparisonSequenceRowName = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), this.profileGrid.getReferenceSequenceName().getValue());
        WritableCellFormat highlightSequenceRowFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(this.profileGrid.getHighlightSequenceName());
        this.highlightSequenceRowName = new ExcelTextCell(highlightSequenceRowFormat, this.profileGrid.getHighlightSequenceName().getValue());
    }

    public void writeExcelFile(int columnsPerTier, int firstColumn, int lastColumn) {
        this.writePortionOfProfileGridInCurrentSheet(columnsPerTier, firstColumn, lastColumn);
        this.writeColorLegend();
        if (this.profileGrid.getUnknownSymbols() != null) {
            this.writeUnknownAminoAcidSheet();
            this.writePlotSimSheet();
        }
        this.writeWorkbook();
        this.closeWorkbook();
    }

    private void writePortionOfProfileGridInCurrentSheet(int columnsPerTier, int firstColumn, int lastColumn) {
        AnalysisOptions analysisOptions = this.profileGrid.getAnalysisOptions();
        int sortType = analysisOptions.sortType;
        String sortTypeName = analysisOptions.alignmentConstants.getSortTypes()[sortType];
        String highlightSequenceName = analysisOptions.highlightSequence.getName();
        this.createSheet(sortTypeName + "-" + highlightSequenceName);
        int numberOfColumns = (int)Math.ceil((lastColumn - firstColumn + 1) / columnsPerTier);
        for (int i = 0; i < numberOfColumns; ++i) {
            this.tier = this.profileGrid.getTier(firstColumn + columnsPerTier * i, firstColumn + columnsPerTier * i + columnsPerTier);
            this.startCol = 0;
            this.startRow = ROWS_PER_TIER * i;
            this.writeTier();
        }
        this.tier = this.profileGrid.getTier(firstColumn + columnsPerTier * numberOfColumns, lastColumn + 1);
        this.startCol = 0;
        this.startRow = ROWS_PER_TIER * numberOfColumns;
        this.writeTier();
        this.startCol = 0;
        this.startRow = ROWS_PER_TIER * (numberOfColumns + 1);
    }

    private void writeUnknownAminoAcidSheet() {
        this.createSheet("Flags");
        this.startCol = 0;
        this.startRow = 0;
        this.writeUnknownAAs();
    }

    private void writePlotSimSheet() {
        AnalysisOptions analysisOptions = this.profileGrid.getAnalysisOptions();
        String weighted = analysisOptions.weightedString;
        this.createSheet("PlotSim_WS_" + this.profileGrid.getAnalysisOptions().windowSize + "_" + weighted);
        this.startCol = 0;
        this.startRow = 0;
        ExcelCell[] currentRow = new ExcelTextCell[2];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        for (int i = 0; i < this.profileGrid.getPlotSimValues().size(); ++i) {
            currentRow[0] = new ExcelTextCell(DefaultFonts.getDefaultFormat(), String.valueOf(i + 1));
            currentRow[1] = new ExcelTextCell(DefaultFonts.getDefaultFormat(), String.valueOf(Double.parseDouble(decimalFormat.format(this.profileGrid.getPlotSimValues().get(i)))));
            this.dataWriter.writeRow(currentRow, this.startCol, this.startRow + i);
        }
    }

    private void writeUnknownAAs() {
        Vector<UnknownSymbol> unknownSymbols = this.profileGrid.getUnknownSymbols();
        int row = this.startRow;
        for (int i = 0; i < unknownSymbols.size(); ++i) {
            UnknownSymbol unknownSymbol = unknownSymbols.get(i);
            for (int j = 0; j < unknownSymbol.getNumberOfSpecies(); ++j) {
                int col = this.startCol + 2;
                UnknownSymbolSpecies unknownSymbolSpecies = unknownSymbol.getUnknownSymbolSpeciesAndLocation(j);
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormat(), unknownSymbol.getSymbol()), 0, row);
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormat(), unknownSymbolSpecies.getSpecies()), 1, row);
                for (int k = 0; k < unknownSymbolSpecies.getNumberOfLocations(); ++k) {
                    this.dataWriter.writeDouble(new ExcelNumericCell(DefaultFonts.getDefaultFormat(), unknownSymbolSpecies.getLocation(k)), col, row);
                    ++col;
                }
                ++row;
            }
        }
    }

    private void writeTier() {
        this.writePositionRow();
        this.writeMajorRow();
        this.writeComparisonSequenceRow();
        this.writeHighlightSequenceRow();
        this.writeAminoAcidNamesAndSymbols();
        this.writeAminoAcidCounts();
    }

    private void writeColorLegend() {
        ExcelTextCell THRESHOLD = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Threshold");
        ExcelTextCell THRESHOLD_COLOR = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Color");
        ExcelTextCell SEQUENCES = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), "Sequences:");
        this.dataWriter.writeString(THRESHOLD, this.startCol, this.startRow);
        this.dataWriter.writeString(THRESHOLD_COLOR, this.startCol + 1, this.startRow);
        ConservationRange conservationRange = this.profileGrid.getAnalysisOptions().conservationRange;
        for (int i = 0; i < conservationRange.getNumberOfRanges(); ++i) {
            this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatAndCentered(), String.valueOf(conservationRange.getThreshold(i))), this.startCol, this.startRow + 1 + i);
            if (conservationRange.getColour(i) != Colour.WHITE) {
                Colour colour = conservationRange.getColour(i) == Colour.BLACK ? Colour.AUTOMATIC : conservationRange.getColour(i);
                this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatWithBackgroundColourAndCentered(colour), ExcelFileWriter.toTitleCase(conservationRange.getColour(i).getDescription())), this.startCol + 1, this.startRow + 1 + i);
                continue;
            }
            this.dataWriter.writeString(new ExcelTextCell(DefaultFonts.getDefaultFormatAndCentered(), ExcelFileWriter.toTitleCase(conservationRange.getColour(i).getDescription())), this.startCol + 1, this.startRow + 1 + i);
        }
        this.dataWriter.writeString(SEQUENCES, this.startCol, this.startRow + 1 + conservationRange.getNumberOfRanges());
        this.dataWriter.writeDouble(new ExcelNumericCell(DefaultFonts.getDefaultFormatAndCentered(), this.profileGrid.getNumberOfSequences()), this.startCol + 1, this.startRow + 1 + conservationRange.getNumberOfRanges());
    }

    private void writePositionRow() {
        this.dataWriter.writeString(POSITION_IN_ALIGNMENT, this.startCol + POSITION_IN_ALIGNMENT_COLUMN_OFFSET, this.startRow + POSITION_IN_ALIGNMENT_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getCells(this.tier.getPositionInAlignmentRow()), this.startCol + POSITION_IN_ALIGNMENT_COLUMN_OFFSET + 1, this.startRow + POSITION_IN_ALIGNMENT_ROW_OFFSET);
    }

    private void writeMajorRow() {
        this.dataWriter.writeString(MAJOR_ROW, this.startCol + MAJOR_COLUMN_OFFSET, this.startRow + MAJOR_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getCells(this.tier.getMajorAminoAcidRow()), this.startCol + MAJOR_COLUMN_OFFSET + 1, this.startRow + MAJOR_ROW_OFFSET);
    }

    private void writeComparisonSequenceRow() {
        this.dataWriter.writeString(this.comparisonSequenceRowName, this.startCol + COMPARISON_SEQUENCE_COLUMN_OFFSET, this.startRow + COMPARISON_SEQUENCE_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getCells(this.tier.getReferenceSequenceRow()), this.startCol + COMPARISON_SEQUENCE_COLUMN_OFFSET + 1, this.startRow + COMPARISON_SEQUENCE_ROW_OFFSET);
    }

    private void writeHighlightSequenceRow() {
        this.dataWriter.writeString(this.highlightSequenceRowName, this.startCol + HIGHLIGHT_SEQUENCE_COLUMN_OFFSET, this.startRow + HIGHLIGHT_SEQUENCE_ROW_OFFSET);
        this.dataWriter.writeRow(ProfileGridCellToExcelCellConverter.getCells(this.tier.getHighlightSequenceRow()), this.startCol + HIGHLIGHT_SEQUENCE_COLUMN_OFFSET + 1, this.startRow + HIGHLIGHT_SEQUENCE_ROW_OFFSET);
    }

    private void writeAminoAcidNamesAndSymbols() {
        this.writeAminoAcidNames(this.startCol + AMINO_ACID_NAMES_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
        this.writeAminoAcidSymbols(this.startCol + AMINO_ACID_SYMBOLS_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
        this.writeAminoAcidSymbols(this.startCol + AMINO_ACID_SYMBOLS_COLUMN_OFFSET + this.tier.getAminoAcidCounts().length + 1, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
    }

    private void writeAminoAcidCounts() {
        this.dataWriter.writeBlock(ProfileGridCellToExcelCellConverter.getCells(this.tier.getAminoAcidCounts()), this.startCol + AMINO_ACID_DATA_COLUMN_OFFSET, this.startRow + AMINO_ACID_DATA_ROW_OFFSET);
    }

    private void writeAminoAcidSymbols(int col, int row) {
        this.dataWriter.writeCol(this.aminoAcidSymbols, col, row);
    }

    private void writeAminoAcidNames(int col, int row) {
        this.dataWriter.writeCol(this.aminoAcidNames, col, row);
    }

    private void setAminoAcidConstants() {
        int i;
        this.aminoAcidConstantsNames = new ExcelTextCell[AminoAcidConstants.CONSTANT_NAMES.length];
        for (i = 0; i < AminoAcidConstants.CONSTANT_NAMES.length; ++i) {
            this.aminoAcidConstantsNames[i] = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), AminoAcidConstants.CONSTANT_NAMES[i]);
        }
        this.aminoAcidConstants = new ExcelNumericCell[AminoAcidConstants.ALL_CONSTANTS.length][];
        for (i = 0; i < AminoAcidConstants.ALL_CONSTANTS.length; ++i) {
            this.aminoAcidConstants[i] = new ExcelNumericCell[AminoAcidConstants.ALL_CONSTANTS[i].length];
        }
        for (i = 0; i < this.profileGrid.getSortedAminoAcidSymbols().length - 1; ++i) {
            AnalysisOptions analysisOptions = this.profileGrid.getAnalysisOptions();
            double[] oldAminoAcidConstants = analysisOptions.alignmentConstants.getConstantsForSymbol(this.profileGrid.getSortedAminoAcidSymbols()[i]);
            for (int j = 0; j < oldAminoAcidConstants.length; ++j) {
                this.aminoAcidConstants[j][i] = new ExcelNumericCell(DefaultFonts.getDefaultFormat(), oldAminoAcidConstants[j]);
            }
        }
    }

    private void setAminoAcidSymbols() {
        String[] oldAminoAcidSymbols = this.profileGrid.getSortedAminoAcidSymbols();
        ExcelTextCell[] nAminoAcidSymbols = new ExcelTextCell[oldAminoAcidSymbols.length];
        for (int i = 0; i < nAminoAcidSymbols.length; ++i) {
            nAminoAcidSymbols[i] = new ExcelTextCell(DefaultFonts.getBoldAndCentered(), oldAminoAcidSymbols[i]);
        }
        this.aminoAcidSymbols = nAminoAcidSymbols;
    }

    private void setAminoAcidNames() {
        String[] oldAminoAcidNames = this.profileGrid.getSortedAminoAcidNames();
        ExcelTextCell[] nAminoAcidNames = new ExcelTextCell[oldAminoAcidNames.length];
        for (int i = 0; i < nAminoAcidNames.length; ++i) {
            nAminoAcidNames[i] = new ExcelTextCell(DefaultFonts.getBoldAndRightAligned(), oldAminoAcidNames[i]);
        }
        this.aminoAcidNames = nAminoAcidNames;
    }

    public void writeWorkbook() {
        try {
            this.workbook.write();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeWorkbook() {
        try {
            this.workbook.close();
        }
        catch (IOException e) {
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private void createSheet(String sheetName) {
        this.currentSheet = this.workbook.createSheet(sheetName, this.workbook.getNumberOfSheets());
        this.dataWriter = new ExcelDataBlockWriter(this.currentSheet);
    }

    private static String toTitleCase(String string) {
        String newString = "";
        boolean cap = true;
        for (int i = 0; i < string.length(); ++i) {
            newString = cap ? newString + String.valueOf(string.charAt(i)).toUpperCase() : newString + string.charAt(i);
            cap = newString.substring(newString.length() - 1, newString.length()).equalsIgnoreCase(" ");
        }
        return newString;
    }

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumIntegerDigits(1);
        formatter.setMinimumIntegerDigits(1);
    }
}

