/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jprofilegrid.model.Numeric;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.model.Tier;
import jxl.format.Colour;
import jxl.format.RGB;

public class ImageFileWriter {
    private final int BORDER_WIDTH = 2;
    private final int CELL_HEIGHT = 15;
    private int CELL_WIDTH = 0;
    private final int HEADER_HEIGHT = 60;
    private final int GRID_OFFSET = 35;
    private List<String> types = Arrays.asList(ImageIO.getWriterFormatNames());

    public void createImage(String fileName, ProfileGrid profileGrid) {
        this.CELL_WIDTH = Math.max(40, 10 * Integer.toString(profileGrid.getNumberOfSequences()).length());
        AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
        String[] names = analysisOptions.alignmentConstants.getNames();
        int heightInRows = names.length;
        Tier entireAlignment = profileGrid.getEntireAlignment();
        Cell[][] aminoAcidEntries = entireAlignment.getAminoAcidCounts();
        int widthInColumns = aminoAcidEntries.length;
        BufferedImage image = new BufferedImage(35 + widthInColumns * this.CELL_WIDTH + 1, heightInRows * 15 + 1 + 60, 5);
        Graphics2D graphic = ImageFileWriter.getGraphics2D(image);
        this.drawHeader(entireAlignment, graphic);
        this.drawLabelsOnLeft(profileGrid.getSortedAminoAcidSymbols(), profileGrid.getSortedAminoAcidNames(), graphic);
        this.drawCells(aminoAcidEntries, graphic);
        BufferedImage sideColumn = new BufferedImage(35 + this.CELL_WIDTH, heightInRows * 15 + 1 + 60, 5);
        graphic = ImageFileWriter.getGraphics2D(sideColumn);
        this.drawLabelsOnLeft(profileGrid.getSortedAminoAcidSymbols(), profileGrid.getSortedAminoAcidNames(), graphic);
        try {
            this.writeImage(image, fileName);
            this.writeImage(sideColumn, fileName.substring(0, fileName.length() - 3) + "sideColumn.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void drawHeader(Tier entireAlignment, Graphics2D graphic) {
        Text[] positionRow = entireAlignment.getPositionInAlignmentRow();
        Text[] majorAminoAcidRow = entireAlignment.getMajorAminoAcidRow();
        Text[] referenceSequenceRow = entireAlignment.getReferenceSequenceRow();
        Text[] highlightSequenceRow = entireAlignment.getHighlightSequenceRow();
        this.drawRow(positionRow, 1, graphic);
        this.drawRow(majorAminoAcidRow, 2, graphic);
        this.drawRow(referenceSequenceRow, 3, graphic);
        this.drawRow(highlightSequenceRow, 4, graphic);
    }

    private void drawRow(Text[] row, int offset, Graphics2D graphic) {
        graphic.setColor(Color.BLACK);
        if (offset == 1) {
            graphic.drawString("Position", 10, offset * 15);
        }
        if (offset == 2) {
            graphic.drawString("Majority", 10, offset * 15);
        }
        if (offset == 3) {
            graphic.drawString("Reference", 10, offset * 15);
        }
        if (offset == 4) {
            graphic.drawString("Highlight", 10, offset * 15);
        }
        for (int i = 0; i < row.length; ++i) {
            graphic.drawString(row[i].getValue(), 35 + this.CELL_WIDTH * (i + 1) + this.CELL_WIDTH / 2 - graphic.getFontMetrics().stringWidth(row[i].getValue()) / 2, offset * 15);
        }
    }

    private void drawLabelsOnLeft(String[] symbols, String[] names, Graphics2D graphic) {
        graphic.setColor(Color.BLACK);
        for (int i = 0; i < symbols.length; ++i) {
            int y1 = (1 + i) * 15 - 4 + 60;
            graphic.drawString(symbols[i], 10, y1);
            int y2 = (1 + i) * 15 - 2 + 60;
            graphic.drawString(names[i], 37, y2);
        }
    }

    private void drawCells(Cell[][] cells, Graphics2D graphic) {
        Color currColor = graphic.getColor();
        int xLocation = 1;
        for (int i = 0; i < cells.length; ++i) {
            int yLocation = 1;
            for (int j = 0; j < cells[i].length; ++j) {
                if (cells[i][j].getFormat().getBorderColor() != null) {
                    this.drawBorder(graphic, xLocation, yLocation, ImageFileWriter.toColor(cells[i][j].getFormat().getBorderColor()));
                } else {
                    this.drawBorder(graphic, xLocation, yLocation, Color.LIGHT_GRAY);
                }
                this.drawCell(graphic, xLocation, yLocation, cells[i][j]);
                ++yLocation;
            }
            ++xLocation;
        }
        graphic.setColor(currColor);
    }

    private void drawCell(Graphics2D g, int i, int j, Cell cell) {
        Format format = cell.getFormat();
        this.setBackgroundColor(g, i, j, format);
        ImageFileWriter.setTextAttributes(g, format);
        StringBuffer textToShow = new StringBuffer(4);
        if (cell instanceof Numeric) {
            if (((Numeric)cell).getValue() != 0.0) {
                if (((Numeric)cell).getValue() < 1.0 && ((Numeric)cell).getValue() != 0.0) {
                    DecimalFormat decForm = new DecimalFormat("#.##");
                    textToShow.append(decForm.format(((Numeric)cell).getValue()));
                } else {
                    textToShow.append(Math.round(((Numeric)cell).getValue()));
                }
            } else {
                textToShow.append("");
            }
        } else {
            textToShow.append(cell.toString());
        }
        g.drawString(textToShow.toString(), 35 + i * this.CELL_WIDTH + this.CELL_WIDTH / 2 - g.getFontMetrics().stringWidth(textToShow.toString()) / 2, j * 15 - 2 + 60);
    }

    private void setBackgroundColor(Graphics2D g, int i, int j, Format format) {
        Colour colour = format.getBackgroundColor();
        if (colour == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(ImageFileWriter.toColor(colour));
        }
        g.fillRect(35 + i * this.CELL_WIDTH + 2, (j - 1) * 15 + 2 + 60, this.CELL_WIDTH - 4 + 2, 13);
    }

    private static void setTextAttributes(Graphics2D g, Format format) {
        Colour fontColor = format.getBackgroundColor();
        if (fontColor != null) {
            fontColor = (double)fontColor.getDefaultRGB().getGreen() < 153.0 ? Colour.WHITE : Colour.BLACK;
        }
        g.setColor(ImageFileWriter.toColor(fontColor));
        if (format.isBold()) {
            Font font = g.getFont();
            Font derivedFont = font.deriveFont(1);
            g.setFont(derivedFont);
        } else {
            Font font = g.getFont();
            Font derivedFont = font.deriveFont(0);
            g.setFont(derivedFont);
        }
    }

    private void drawBorder(Graphics2D g, int i, int j, Color borderColor) {
        g.setColor(borderColor);
        for (int k = 1; k < 2; ++k) {
            Rectangle rect = new Rectangle(this.CELL_WIDTH - 2 * k + 1, 15 - 2 * k + 1);
            rect.x = 35 + i * this.CELL_WIDTH + k;
            rect.y = (j - 1) * 15 + 60 + k;
            g.draw(rect);
        }
    }

    private static Color toColor(Colour colour) {
        if (colour == null) {
            return Color.BLACK;
        }
        colour = Colour.getInternalColour(colour.getValue());
        RGB rgb = colour.getDefaultRGB();
        Color color = new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        return color;
    }

    private static Graphics2D getGraphics2D(BufferedImage image) {
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public BufferedImage createImage(Rectangle region, String fileName) throws AWTException, IOException {
        BufferedImage image = new Robot().createScreenCapture(region);
        this.writeImage(image, fileName);
        return image;
    }

    public static BufferedImage newCreateImage(Component cmp, String filename) {
        Rectangle size = cmp.getBounds();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        cmp.paint(g2);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            ImageIO.write((RenderedImage)myImage, "png", out);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }

    public void writeImage(BufferedImage image, String fileName) throws IOException {
        if (fileName == null) {
            return;
        }
        int offset = fileName.lastIndexOf(".");
        if (offset == -1) {
            String message = "file suffix was not specified";
            throw new IOException(message);
        }
        String type = fileName.substring(offset + 1);
        if (!this.types.contains(type)) {
            String message = "unknown writer file suffix (" + type + ")";
            throw new IOException(message);
        }
        ImageIO.write((RenderedImage)image, type, new File(fileName));
    }
}

