/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.PriorityQueue;
import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.ConservationRange;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.model.Tier;

public class PyMOLScriptWriter {
    public static void outputPyMOLScript(ProfileGrid profileGrid, AnalysisOptions analysisOptions, String inputFile, String outputFile, String pdbFile, int startIndex, int endIndex) {
        try {
            int i;
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(outputFile));
            int[] positionInAlignmentRow = profileGrid.getEntireAlignment().getPositonInAlignmentRowWithoutSkippingGaps();
            int[][] aaCounts = profileGrid.getEntireAlignment().getIntegerAminoAcidCounts();
            double numberOfSequences = profileGrid.getNumberOfSequences();
            fileWriter.write("# JProfileGrid PyMOL Script\n");
            fileWriter.write("# Source Alignment File: " + inputFile + "\n");
            String templateSequenceName = profileGrid.getReferenceSequenceName().getValue();
            String highlightSequenceName = profileGrid.getHighlightSequenceName().getValue();
            fileWriter.write("# Template Sequence: " + templateSequenceName + "\n");
            fileWriter.write("# Highlight Sequence: " + (highlightSequenceName.equalsIgnoreCase("") ? "None Selected" : highlightSequenceName) + "\n\n");
            fileWriter.write("# Change " + pdbFile + " below to the path of the PDB file.\n");
            fileWriter.write("load " + pdbFile + "\n\n");
            fileWriter.write("# Various viewing settings.\n");
            fileWriter.write("viewport 750, 600\n");
            fileWriter.write("set cartoon_smooth_loops, 1\n");
            fileWriter.write("set cartoon_side_chain_helper, 1\n");
            fileWriter.write("set specular, 0.00000\n");
            fileWriter.write("set depth_cue, off\n");
            fileWriter.write("set ray_trace_fog, 0\n");
            fileWriter.write("set ray_shadows, 0\n\n");
            fileWriter.write("# Selects residues that are 100% conserved.\n");
            fileWriter.write("select ident, ");
            boolean first = true;
            for (int i2 = 0; i2 < aaCounts.length; ++i2) {
                for (int j = 0; j < aaCounts[i2].length - 1; ++j) {
                    if ((double)aaCounts[i2][j] != numberOfSequences) continue;
                    if (first) {
                        fileWriter.write("resi " + positionInAlignmentRow[i2]);
                        first = false;
                        continue;
                    }
                    fileWriter.write("+" + positionInAlignmentRow[i2]);
                }
            }
            fileWriter.write("\n");
            fileWriter.write("# Selects residues that pass the highest threshold value.\n");
            first = true;
            ConservationRange cRange = analysisOptions.conservationRange;
            double maxThreshold = 0.0;
            for (i = 0; i < cRange.getNumberOfRanges(); ++i) {
                if (!(cRange.getThreshold(i) > maxThreshold)) continue;
                maxThreshold = cRange.getThreshold(i);
            }
            fileWriter.write("select bin" + (int)(maxThreshold * 100.0) + ", ");
            for (i = 0; i < aaCounts.length; ++i) {
                boolean columnOutputted = false;
                for (int j = 0; j < aaCounts[i].length - 1; ++j) {
                    if (columnOutputted || !((double)aaCounts[i][j] / numberOfSequences >= maxThreshold)) continue;
                    if (first) {
                        fileWriter.write("resi " + positionInAlignmentRow[i]);
                        first = false;
                    } else {
                        fileWriter.write("+" + positionInAlignmentRow[i]);
                    }
                    columnOutputted = true;
                }
            }
            fileWriter.write("\n\n");
            fileWriter.write("# Selects residues that are highlighted.\n");
            first = true;
            Text[] templateSequenceRow = profileGrid.getEntireAlignment().getReferenceSequenceRow();
            Text[] highlightSequenceRow = profileGrid.getEntireAlignment().getHighlightSequenceRow();
            int startValue = analysisOptions.positionRowStart;
            int gapSubtractAmount = 0;
            if (!highlightSequenceName.equalsIgnoreCase("")) {
                fileWriter.write("select highlight, ");
                for (int i3 = 0; i3 < templateSequenceRow.length; ++i3) {
                    String currentTemplateAA = templateSequenceRow[i3].getValue();
                    if (!(currentTemplateAA.equalsIgnoreCase(".") || currentTemplateAA.equalsIgnoreCase("*") || currentTemplateAA.equalsIgnoreCase("-"))) {
                        if (i3 >= highlightSequenceRow.length || currentTemplateAA.equalsIgnoreCase(highlightSequenceRow[i3].getValue())) continue;
                        if (first) {
                            fileWriter.write("resi " + (i3 + startValue + gapSubtractAmount));
                            first = false;
                            continue;
                        }
                        fileWriter.write("+" + (i3 + startValue + gapSubtractAmount));
                        continue;
                    }
                    --gapSubtractAmount;
                }
            } else {
                fileWriter.write("# Template and highlight sequences are the same.");
            }
            fileWriter.write("\n\n");
            fileWriter.write("# Similarity plot calculation results.\n");
            PriorityQueue<LinkAndMotif> linksAndMotifs = new PriorityQueue<LinkAndMotif>();
            int currentMotif = 0;
            boolean computed = false;
            int numberOfMotifs = profileGrid.getNumberOfMotifRegions();
            for (int i4 = 0; i4 < numberOfMotifs; ++i4) {
                computed = true;
                Tier currentTier = profileGrid.getMotifRegion(i4);
                int currentTierLeft = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                int currentTierRight = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[currentTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                boolean finishedFindingMotifEnd = false;
                while (i4 + 1 < numberOfMotifs && !finishedFindingMotifEnd) {
                    Tier nextTier = profileGrid.getMotifRegion(i4 + 1);
                    int nextTierLeft = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                    if (nextTierLeft <= currentTierRight + 1) {
                        currentTierRight = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[nextTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                        ++i4;
                        continue;
                    }
                    finishedFindingMotifEnd = true;
                }
                linksAndMotifs.add(new LinkAndMotif(false, currentMotif, currentTierLeft, currentTierRight));
                ++currentMotif;
            }
            int currentVariableRegion = 0;
            int numberOfVariableRegions = profileGrid.getNumberOfVariableRegions();
            for (int i5 = 0; i5 < numberOfVariableRegions; ++i5) {
                computed = true;
                Tier currentTier = profileGrid.getVariableRegion(i5);
                int currentTierLeft = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                int currentTierRight = currentTier.getPositonInAlignmentRowWithoutSkippingGaps()[currentTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                boolean finishedFindingVariableEnd = false;
                while (i5 + 1 < numberOfVariableRegions && !finishedFindingVariableEnd) {
                    Tier nextTier = profileGrid.getVariableRegion(i5 + 1);
                    int nextTierLeft = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[0];
                    if (nextTierLeft <= currentTierRight + 1) {
                        currentTierRight = nextTier.getPositonInAlignmentRowWithoutSkippingGaps()[nextTier.getPositonInAlignmentRowWithoutSkippingGaps().length - 1];
                        ++i5;
                        continue;
                    }
                    finishedFindingVariableEnd = true;
                }
                linksAndMotifs.add(new LinkAndMotif(true, currentVariableRegion, currentTierLeft, currentTierRight));
                ++currentVariableRegion;
            }
            boolean pastStart = false;
            boolean isFirstPastStart = false;
            boolean isLastBeforeEnd = false;
            boolean pastEnd = false;
            int currentMotifNumber = 0;
            int currentVariableRegionNumber = 0;
            while (!linksAndMotifs.isEmpty()) {
                LinkAndMotif currentLinkOrMotif = (LinkAndMotif)linksAndMotifs.remove();
                if (!pastStart && currentLinkOrMotif.getStartIndex() <= startIndex && startIndex <= currentLinkOrMotif.getEndIndex()) {
                    pastStart = true;
                    isFirstPastStart = true;
                }
                if (!pastStart) continue;
                if (!pastEnd && currentLinkOrMotif.getEndIndex() >= endIndex && currentLinkOrMotif.getStartIndex() <= endIndex) {
                    pastEnd = true;
                    isLastBeforeEnd = true;
                }
                if (pastEnd && !isLastBeforeEnd) continue;
                if (currentLinkOrMotif.isLink()) {
                    currentLinkOrMotif.setNumber(currentVariableRegionNumber);
                    ++currentVariableRegionNumber;
                } else {
                    currentLinkOrMotif.setNumber(currentMotifNumber);
                    ++currentMotifNumber;
                }
                if (isFirstPastStart) {
                    isFirstPastStart = false;
                    fileWriter.write(currentLinkOrMotif.getPyMOLStringWithoutRanges() + startIndex + "-");
                    if (isLastBeforeEnd) {
                        fileWriter.write(endIndex + "\n");
                        isLastBeforeEnd = false;
                        continue;
                    }
                    fileWriter.write(currentLinkOrMotif.getEndIndex() + "\n");
                    continue;
                }
                if (isLastBeforeEnd) {
                    fileWriter.write(currentLinkOrMotif.getPyMOLStringWithoutRanges() + currentLinkOrMotif.getStartIndex() + "-" + endIndex);
                    isLastBeforeEnd = false;
                    continue;
                }
                fileWriter.write(currentLinkOrMotif.getPyMOLString() + "\n");
            }
            if (!computed) {
                fileWriter.write("# Similarity plot has not been computed in JProfileGrid.\n");
            } else {
                int i6;
                DecimalFormat formatter = new DecimalFormat();
                formatter.setMaximumFractionDigits(6);
                formatter.setMinimumFractionDigits(6);
                fileWriter.write("\n\n# Colors links light gray.\n");
                for (int i7 = 0; i7 < currentVariableRegionNumber; ++i7) {
                    fileWriter.write("color gray80, var" + i7 + "\n");
                }
                fileWriter.write("\n# Coloring ranges for motifs (from red to green).\n");
                double colorStepSize = 1.0 / (double)currentMotifNumber;
                for (i6 = 0; i6 < currentMotifNumber; ++i6) {
                    fileWriter.write("set_color col" + i6 + ", [" + formatter.format(1.0 - (double)i6 * colorStepSize) + ", " + formatter.format((double)i6 * colorStepSize) + ", " + formatter.format(0L) + "]\n");
                }
                fileWriter.write("\n# Perform the coloring of the motifs.\n");
                for (i6 = 0; i6 < currentMotifNumber; ++i6) {
                    fileWriter.write("color col" + i6 + ", mot" + i6 + "\n");
                }
            }
            fileWriter.write("\n# Cartoon-render everything.\n");
            fileWriter.write("hide all\n");
            fileWriter.write("bg_color white\n");
            fileWriter.write("show cartoon, all");
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkAndMotif
    implements Comparable<LinkAndMotif> {
        private boolean isLink;
        private int number;
        private int startIndex;
        private int endIndex;

        public LinkAndMotif(boolean nIsLink, int nNumber, int nStartIndex, int nEndIndex) {
            this.isLink = nIsLink;
            this.number = nNumber;
            this.startIndex = nStartIndex;
            this.endIndex = nEndIndex;
        }

        @Override
        public int compareTo(LinkAndMotif o) {
            if (this.startIndex > o.getStartIndex()) {
                return 1;
            }
            return -1;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getPyMOLString() {
            String output = new String("select ");
            output = this.isLink ? output + "var" : output + "mot";
            output = output + this.number;
            output = output + ", resi " + this.startIndex + "-" + this.endIndex;
            return output;
        }

        public boolean isLink() {
            return this.isLink;
        }

        public void setNumber(int nNumber) {
            this.number = nNumber;
        }

        public String getPyMOLStringWithoutRanges() {
            String output = new String("select ");
            output = this.isLink ? output + "var" : output + "mot";
            output = output + this.number;
            output = output + ", resi ";
            return output;
        }
    }
}

