/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers.excel;

import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WriteException;

public class DefaultFonts {
    public static WritableCellFormat getDefaultFormatWithBackgroundColourAndCentered(Colour colour) {
        WritableCellFormat format = DefaultFonts.getDefaultFormatWithBackgroundColour(colour);
        try {
            format.setAlignment(Alignment.CENTRE);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return format;
    }

    public static WritableCellFormat getDefaultFormatWithBackgroundColour(Colour colour) {
        WritableCellFormat format = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12));
        try {
            format.setBackground(colour);
            DefaultFonts.enableShrinkToFit(format);
            DefaultFonts.setDefaultAlignment(format);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return format;
    }

    public static WritableCellFormat getDefaultFormatAndCentered() {
        WritableCellFormat format = DefaultFonts.getDefaultFormat();
        try {
            format.setAlignment(Alignment.CENTRE);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return format;
    }

    public static WritableCellFormat getDefaultFormat() {
        WritableCellFormat defaultFont = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12));
        DefaultFonts.enableShrinkToFit(defaultFont);
        DefaultFonts.setDefaultAlignment(defaultFont);
        return defaultFont;
    }

    public static WritableCellFormat[] getDefaultFormatBlock(int lengthOfBlock) {
        WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
        for (int i = 0; i < block.length; ++i) {
            block[i] = DefaultFonts.getDefaultFormat();
        }
        return block;
    }

    public static WritableCellFormat[][] getDefaultFormatBlock(int lengthOfBlock, int widthOfBlock) {
        WritableCellFormat[][] block = new WritableCellFormat[lengthOfBlock][widthOfBlock];
        for (int i = 0; i < block.length; ++i) {
            block[i] = DefaultFonts.getDefaultFormatBlock(widthOfBlock);
        }
        return block;
    }

    public static WritableCellFormat getBold() {
        WritableCellFormat defaultFontInBold = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD));
        DefaultFonts.enableShrinkToFit(defaultFontInBold);
        DefaultFonts.setDefaultAlignment(defaultFontInBold);
        return defaultFontInBold;
    }

    public static WritableCellFormat getBoldAndCentered() {
        WritableCellFormat format = DefaultFonts.getBold();
        try {
            format.setAlignment(Alignment.CENTRE);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return format;
    }

    public static WritableCellFormat[] getBoldAndCenteredBlock(int lengthOfBlock) {
        WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
        for (int i = 0; i < block.length; ++i) {
            block[i] = DefaultFonts.getBoldAndCentered();
        }
        return block;
    }

    public static WritableCellFormat getBoldAndRightAligned() {
        WritableCellFormat format = DefaultFonts.getBold();
        try {
            format.setAlignment(Alignment.RIGHT);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return format;
    }

    public static WritableCellFormat[] getBoldBlock(int lengthOfBlock) {
        WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
        for (int i = 0; i < block.length; ++i) {
            block[i] = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD));
        }
        return block;
    }

    private static void enableShrinkToFit(WritableCellFormat format) {
        try {
            format.setShrinkToFit(true);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private static void setDefaultAlignment(WritableCellFormat format) {
        try {
            format.setAlignment(Alignment.RIGHT);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }
}

