/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers.excel;

import jprofilegrid.writers.excel.ExcelCell;
import jprofilegrid.writers.excel.ExcelNumericCell;
import jprofilegrid.writers.excel.ExcelTextCell;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Pattern;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelDataBlockWriter {
    private WritableSheet sheet;

    public ExcelDataBlockWriter(WritableSheet nSheet) {
        this.sheet = nSheet;
    }

    public void writeString(ExcelTextCell textCell, int col, int row) {
        this.addCell(col, row, textCell);
    }

    public void writeDouble(ExcelNumericCell numericCell, int col, int row) {
        this.addNumericCell(col, row, numericCell);
    }

    public void writeRow(ExcelCell[] excelCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < excelCells.length) {
            this.addCell(col, startRow, excelCells[i]);
            ++i;
            ++col;
        }
    }

    public void writeCol(ExcelCell[] excelCells, int startCol, int startRow) {
        int i = 0;
        int row = startRow;
        while (i < excelCells.length) {
            this.addCell(startCol, row, excelCells[i]);
            ++i;
            ++row;
        }
    }

    public void writeBlock(ExcelCell[][] excelCells, int startCol, int startRow) {
        int i = 0;
        int col = startCol;
        while (i < excelCells.length) {
            this.writeCol(excelCells[i], col, startRow);
            ++i;
            ++col;
        }
    }

    private void addCell(int col, int row, ExcelCell excelCell) {
        if (excelCell instanceof ExcelTextCell) {
            ExcelTextCell excelTextCell = (ExcelTextCell)excelCell;
            try {
                this.sheet.addCell(new Number(col, row, Double.parseDouble(excelTextCell.getValue()), (CellFormat)excelTextCell.getFormat()));
            }
            catch (NumberFormatException e) {
                this.addTextCellWithoutParsingNumber(col, row, excelTextCell);
            }
            catch (RowsExceededException e) {
            }
            catch (WriteException e) {}
        } else {
            ExcelNumericCell excelNumericCell = (ExcelNumericCell)excelCell;
            this.addNumericCell(col, row, excelNumericCell);
        }
    }

    private void addTextCellWithoutParsingNumber(int col, int row, ExcelTextCell textCell) {
        try {
            WritableCellFormat format = textCell.getFormat();
            if (format.getBackgroundColour() == Colour.BLACK) {
                format.setBackground(Colour.AUTOMATIC);
            }
            if (format.getBackgroundColour().getValue() == Colour.WHITE.getValue()) {
                format = this.extractAllFormattingExceptBackground(format);
            }
            this.sheet.addCell(new Label(col, row, textCell.getValue(), (CellFormat)format));
        }
        catch (RowsExceededException e) {
        }
        catch (WriteException e) {
            // empty catch block
        }
    }

    private void addNumericCell(int col, int row, ExcelNumericCell numericCell) {
        try {
            WritableCellFormat format = numericCell.getFormat();
            if (format.getBackgroundColour() == Colour.BLACK) {
                format.setBackground(Colour.AUTOMATIC);
            }
            if (format.getBackgroundColour().getValue() == Colour.WHITE.getValue()) {
                format = this.extractAllFormattingExceptBackground(format);
            }
            if (numericCell.getValue() != 0.0) {
                this.sheet.addCell(new Number(col, row, numericCell.getValue(), (CellFormat)format));
            } else {
                this.sheet.addCell(new Label(col, row, "", (CellFormat)format));
            }
        }
        catch (RowsExceededException e) {
        }
        catch (WriteException e) {
            // empty catch block
        }
    }

    private WritableCellFormat extractAllFormattingExceptBackground(WritableCellFormat oldFormat) {
        try {
            oldFormat.setBackground(Colour.WHITE, Pattern.NONE);
            return oldFormat;
        }
        catch (WriteException writeException) {
            return null;
        }
    }
}

