/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers.excel;

import jprofilegrid.model.Cell;
import jprofilegrid.model.Numeric;
import jprofilegrid.model.Text;
import jprofilegrid.writers.excel.ExcelCell;
import jprofilegrid.writers.excel.ExcelNumericCell;
import jprofilegrid.writers.excel.ExcelTextCell;
import jprofilegrid.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.write.WritableCellFormat;

public abstract class ProfileGridCellToExcelCellConverter {
    public static ExcelCell[][] getCells(Cell[][] cells) {
        ExcelCell[][] excelCells = new ExcelCell[cells.length][];
        for (int i = 0; i < cells.length; ++i) {
            excelCells[i] = ProfileGridCellToExcelCellConverter.getCells(cells[i]);
        }
        return excelCells;
    }

    public static ExcelCell[] getCells(Cell[] cells) {
        ExcelCell[] excelCells = new ExcelCell[cells.length];
        for (int i = 0; i < excelCells.length; ++i) {
            excelCells[i] = ProfileGridCellToExcelCellConverter.getCell(cells[i]);
        }
        return excelCells;
    }

    private static ExcelCell getCell(Cell cell) {
        if (cell instanceof Numeric) {
            return ProfileGridCellToExcelCellConverter.getNumericCell((Numeric)cell);
        }
        return ProfileGridCellToExcelCellConverter.getTextCell((Text)cell);
    }

    private static ExcelNumericCell getNumericCell(Numeric cell) {
        WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(cell);
        double value = cell.getValue();
        return new ExcelNumericCell(format, value);
    }

    private static ExcelTextCell getTextCell(Text cell) {
        WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat(cell);
        String value = cell.getValue();
        return new ExcelTextCell(format, value);
    }
}

