/*
 * Decompiled with CFR 0.152.
 */
package jprofilegrid.writers.excel;

import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WriteException;

public class ProfileGridFormatToExcelFormatConverter {
    public static Colour[] JEXCELAPI_COLORS = new Colour[]{Colour.WHITE, Colour.GRAY_25, Colour.YELLOW, Colour.ORANGE, Colour.GREEN, Colour.RED, Colour.SKY_BLUE};

    public static WritableCellFormat extractWritableCellFormat(Cell cell) {
        Format oldFormat = cell.getFormat();
        WritableCellFormat newFormat = oldFormat.isBold() ? new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD)) : new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.NO_BOLD));
        ProfileGridFormatToExcelFormatConverter.extractBorders(oldFormat, newFormat);
        ProfileGridFormatToExcelFormatConverter.extractAlignment(oldFormat, newFormat);
        ProfileGridFormatToExcelFormatConverter.extractBackgroundColor(oldFormat, newFormat);
        ProfileGridFormatToExcelFormatConverter.extractBorderColor(oldFormat, newFormat);
        try {
            newFormat.setShrinkToFit(true);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        return newFormat;
    }

    private static void extractBorders(Format oldFormat, WritableCellFormat newFormat) {
        try {
            if (oldFormat.hasTopBorder()) {
                newFormat.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
            }
            if (oldFormat.hasBottomBorder()) {
                newFormat.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
            }
            if (oldFormat.hasLeftBorder()) {
                newFormat.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
            }
            if (oldFormat.hasRightBorder()) {
                newFormat.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
            }
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private static void extractBorderColor(Format oldFormat, WritableCellFormat newFormat) {
        try {
            Colour newColour = oldFormat.getBorderColor();
            if (newColour != null) {
                newFormat.setBorder(Border.LEFT, BorderLineStyle.MEDIUM, newColour);
                newFormat.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM, newColour);
                newFormat.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM, newColour);
                newFormat.setBorder(Border.TOP, BorderLineStyle.MEDIUM, newColour);
            }
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private static void extractAlignment(Format oldFormat, WritableCellFormat newFormat) {
        try {
            newFormat.setAlignment(ProfileGridFormatToExcelFormatConverter.convertAlignment(oldFormat.getAlignment()));
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private static void extractBackgroundColor(Format oldFormat, WritableCellFormat newFormat) {
        try {
            Colour newColour = oldFormat.getBackgroundColor();
            if (newColour != null) {
                newFormat.setBackground(newColour);
                if ((double)newColour.getDefaultRGB().getGreen() < 153.0) {
                    WritableFont newFont = new WritableFont(newFormat.getFont());
                    newFont.setColour(Colour.WHITE);
                    newFormat.setFont(newFont);
                }
            }
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private static Alignment convertAlignment(int oldAlignment) {
        if (oldAlignment == Format.LEFT_ALIGNED) {
            return Alignment.LEFT;
        }
        if (oldAlignment == Format.CENTER_ALIGNED) {
            return Alignment.CENTRE;
        }
        if (oldAlignment == Format.RIGHT_ALIGNED) {
            return Alignment.RIGHT;
        }
        return null;
    }
}

