package jprofilegrid.calculations;

import java.util.List;

import jprofilegrid.constants.AlignmentConstants;
import jprofilegrid.constants.AminoAcidConstants;
import jprofilegrid.constants.DNAConstants;

public class MultipleSequenceAlignment
{
	private AlignmentConstants alignmentConstants = new AminoAcidConstants();
	private MultipleSequenceAnalysis multipleSequenceAnalysis;
	private List <String> header;
	private List <Sequence> sequences;
	int minSequenceLength;
	private String alignmentName = "";

	public MultipleSequenceAlignment(List <String> header, List<Sequence> sequences)
	{
		this.header = header;
		this.sequences = sequences;
		findMinSequenceLength();
	}

	public AlignmentConstants getAlignmentConstants()
	{
		return alignmentConstants;
	}

	public List <String> getHeader()
	{
		return header;
	}

	public List<Sequence> getSequences()
	{
		return sequences;
	}

	private void findMinSequenceLength()
	{
		minSequenceLength = Integer.MAX_VALUE;
		for(Sequence sequence : sequences)
		{
			int length = sequence.getActualLength();
			if( length < minSequenceLength)
				minSequenceLength = length;
		}

		if(minSequenceLength == Integer.MAX_VALUE)
			minSequenceLength = 0;
	}

	public void setAlignmentName(String alignmentName)
	{
		this.alignmentName = alignmentName;
	}

	public void setAlignmentType(int alignmentType)
	{
		alignmentConstants = alignmentType == AlignmentConstants.DNA ? new DNAConstants() : new AminoAcidConstants();
	}

	public void setMultipleSequenceAnalysis(MultipleSequenceAnalysis multipleSequenceAnalysis)
	{
		this.multipleSequenceAnalysis = multipleSequenceAnalysis;
	}

	public MultipleSequenceAnalysis getMultipleSequenceAnalysis()
	{
		return multipleSequenceAnalysis;
	}

	public int getMinSequenceLength()
	{
		return minSequenceLength;
	}

	public String getAlignmentName()
	{
		return alignmentName;
	}
}
