package jprofilegrid.calculations;

public class Sequence implements Comparable<Sequence>
{
	private String sequenceNames;
	private StringBuffer sequenceBuffer = new StringBuffer();
	private int check, length;
	private double weight;
	private boolean sequenceNamePassedRegexFilter = true,
				    sequencePassedRegexFilter = true,
				    sequencePassedMetaDataFilter = true,
				    sequencePassedSelectionFilter = true;

	public Sequence( String nsequenceNames, int nLength, int nCheck, double nWeight )
	{
		sequenceNames = nsequenceNames;
		length = nLength;
		check = nCheck;
		weight = nWeight;
	}

	public Sequence( String nsequenceNames, String nSequence, int nLength, int nCheck, double nWeight )
	{
		sequenceNames = nsequenceNames;
		length = nLength;
		check = nCheck;
		weight = nWeight;
		sequenceBuffer = new StringBuffer(nSequence);
	}

	public static Sequence deepCopy(Sequence originalSequence)
	{
		return(new Sequence(new String(originalSequence.getName()),
											new String(originalSequence.getSequence()),
											new Integer(originalSequence.getLength()),
											new Integer(originalSequence.getCheck()),
											new Double(originalSequence.getWeight())));
	}

	public String getName()
	{
		return( sequenceNames );
	}

	public int getLength()
	{
		return( length );
	}

	public int getCheck()
	{
		return( check );
	}

	public double getWeight()
	{
		return( weight );
	}

	public String getEntireSequence()
	{
		return sequenceBuffer.toString();
	}

	public String getAminoAcid( int index )
	{
		if( index < sequenceBuffer.length() )
			return( sequenceBuffer.substring(index, index + 1));
		return( null );
	}

	public char getAminoAcidChar(int index)
	{
		return sequenceBuffer.charAt(index);
	}

	public String toString()
	{

		return( new String( "Name:\t" + sequenceNames + "\tLength:\t" + length +
				"\tCheck:\t" + check + "\tWeight:\t" + weight) );
	}

	public int getActualLength()
	{
		return sequenceBuffer.length();
	}

	public void addToSequence(String nSequence)
	{
		sequenceBuffer.append(nSequence);
	}

	public String getSequence()
	{
		return sequenceBuffer.toString();
	}

	public void setSequenceNamePassedRegexFilter(boolean sequenceNamePassedRegexFilter)
	{
		this.sequenceNamePassedRegexFilter = sequenceNamePassedRegexFilter;
	}

	public void setSequencePassedRegexFilter(boolean sequencePassedRegexFilter)
	{
		this.sequencePassedRegexFilter = sequencePassedRegexFilter;
	}

	public void setSequencePassedSelectionFilter(boolean sequencePassedSelectionFilter)
	{
		this.sequencePassedSelectionFilter = sequencePassedSelectionFilter;
	}

	public void setSequencePassedMetaDataFilter(boolean sequencePassedMetaDataFilter)
	{
		this.sequencePassedMetaDataFilter = sequencePassedMetaDataFilter;
	}

	public boolean getSequenceNamePassedRegexFilter()
	{
		return sequenceNamePassedRegexFilter;
	}

	public boolean getSequencePassedRegexFilter()
	{
		return sequencePassedRegexFilter;
	}

	public boolean getSequencePassedMetaDataFilter()
	{
		return sequencePassedMetaDataFilter;
	}

	public boolean getSequencePassedSelectionFilter()
	{
		return sequencePassedSelectionFilter;
	}

	@Override
	public int compareTo(Sequence sequence)
	{
		return sequenceNames.compareTo(sequence.getName());
	}
}
