package jprofilegrid.calculations;

public class Symbol implements Comparable<Symbol>
{
	private String name;
	private String symbol;
	private char symbolChar;
	private double properties[];
	private int compType;
	boolean ascending = false;

	public Symbol(String nName, String nSymbol, double[] nProperties, int nCompType, boolean nAscending)
	{
		name = nName;
		symbol = nSymbol;
		if(symbol.length() > 0)
			symbolChar = symbol.charAt(0);
		properties = nProperties;
		compType = nCompType;
		ascending = nAscending;
	}

	public int compareTo(Symbol other)
	{
		if( ascending )
		{
			if( compType == 1 )
				return( name.compareTo(other.getName()) );
			if( compType == 0 )
				return( symbol.compareTo(other.getSymbol()) );

			if( getComparisonValue() > other.getComparisonValue() )
				return 1;
			if( getComparisonValue() < other.getComparisonValue() )
				return -1;
		}
		else
		{
			if( compType == 1 )
				return( -1 * name.compareTo(other.getName()) );
			if( compType == 0 )
				return( -1 * symbol.compareTo(other.getSymbol()) );

			if( getComparisonValue() < other.getComparisonValue() )
				return 1;
			if( getComparisonValue() > other.getComparisonValue() )
				return -1;
		}

		return 0;
	}

	public Double getComparisonValue()
	{
		return( properties[compType - 2] );
	}

	public String getName()
	{
		return name;
	}

	public String getSymbol()
	{
		return symbol;
	}

	public char getSymbolChar()
	{
		return symbolChar;
	}
}
