package jprofilegrid.constants;

import java.awt.Color;
import java.util.HashMap;
import java.util.Hashtable;

public class AminoAcidConstants extends AlignmentConstants
{
	private static String AMINO_ACID_NAMES[] = {"ala", "cys", "asp", "glu", "phe", "gly", "his", "ile",
		"lys", "leu", "met", "asn", "pro", "gln", "arg", "ser", "thr", "val", "trp", "tyr", "gap"};
	private static String AMINO_ACID_SYMBOLS[] = {"A", "C", "D", "E" ,"F" ,"G" ,"H", "I", "K",
		"L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y", "-"};

	public static String CONSTANT_NAMES[] = { "Age", "Flex", "FreqK", "Hpathy", "Hphob", "Helix", "Mutab", "Grnthm", "ASA", "Taylor", "Volume", "z1", "z2", "z3", "z4", "z5"};
	private static String SORT_TYPES[] =  {  "Alphabetical-Code", "Alphabetical-Name", "Age", "Flexibility",
			"Frequency-EcoliK12", "Hydropathy", "Hydrophobicity", "Helix-Propensity", "Mutability-Dayhoff",
			"Mutability-Grantham","Surface-Area", "Taylor", "Volume", "z1-lipophilicity", "z2-size & polarisability", "z3-polarity", "z4-electronic", "z5-electronic" };
	public static double FREQK[] = { 9.5, 1.2, 5.1, 5.8, 3.9, 7.3, 2.3, 6.0, 4.4, 10.7, 2.8, 3.9, 4.4, 4.4, 5.5, 5.8, 5.4, 7.1, 1.5, 2.9 };
	public static double AGE[] = { 2, 13, 3, 7, 14, 1, 11, 10, 12, 8, 16, 10, 5, 10, 9, 6, 8, 4, 17, 15 };
	public static double ASA[] = { 115, 135, 150, 190, 210, 75, 195, 175, 200, 170, 185, 160, 145, 180, 225, 115, 140, 155, 255, 230 };
	public static double FLEX[] = { 6.0, 9.5, 8.0, 13.0, 6.4, 20.0, 7.1, 8.7, 14.7, 19.6, 17.7, 8.7, 6.0, 10.7, 13.9, 16.1, 9.3, 10.0, 6.7, 6.2 };
	public static double HPATHY[] = { 1.8, 2.5, -3.5, -3.5, 2.8, -0.4, -3.2, 4.5, -3.9, 3.8, 1.9, -3.5, -1.6, -3.5, -4.5, -0.8, -0.7, 4.2, -0.9, -1.3 } ;
	public static double HPHOB[] = { -0.40, 0.17, -1.31, -0.91, 1.92, -0.67, -0.64, 1.25, -0.67, 1.22, 1.02, -0.92, -0.49, -1.22, -0.59, -0.55, -0.28, 0.91, 0.50, 1.67 };
	public static double MUTAB[] = { 100, 20, 106, 93, 41, 49, 66, 96, 56, 40, 94, 134, 56, 102, 65, 120, 97, 74, 18, 41 };
	public static double GRNTHM[] = { 0.75, 0.31, 0.93, 0.82, 0.83, 0.66, 0.53, 0.89, 0.76, 0.92, 0.58, 0.87, 0.67, 0.79, 0.68, 0.76, 0.63, 0.86, 0.58, 0.64 };
	public static double HELIX[] = { -0.27, 0.64, 0.52, 0.21, 0.73, 1.7, 0.57, 0.44, 0.019, 0.095, 0.25, 0.69, 3.8, 0.28, -0.052, 0.52, 0.95, 0.77, 0.69, 0.42 };
	public static double TAYLOR[] = {1, 20, 15, 14, 6, 18, 9, 3, 11, 4, 5, 12, 19, 13, 10, 16, 17, 2, 8, 7, 21};
	public static double VOLUME[] = { 67, 86, 91, 114, 135, 48, 118, 124, 135, 124, 124, 96, 90, 109, 148, 73, 93, 105, 163, 141 };
	public static double Z1[] = { 0.24, 0.84, 3.98, 3.11, -4.22, 2.05, 2.47, -3.89, 2.29, -4.28, -2.85, 3.05, -1.66, 1.75, 3.52, 2.39, 0.75, -2.59, -4.36, -2.54 };
	public static double Z2[] = { -2.32, -1.67, 0.93, 0.26, 1.94, -4.06, 1.95, -1.73, 0.89, -1.30, -0.22, 1.62, 0.27, 0.50, 2.50, -1.07, -2.18, -2.64, 3.94, 2.44 };
	public static double Z3[] = { 0.60, 3.71, 1.93, -0.11, 1.06, 0.36, 0.26, -1.71, -2.49, -1.49, 0.47, 1.04, 1.84, -1.44, -3.50, 1.15, -1.12, -1.54, 0.59, 0.43 };
	public static double Z4[] = { -0.14, 0.18, -2.46, -3.04, 0.54, -0.82, 3.90, -0.84, 1.49, -0.72, 1.94, -1.15, 0.70, -1.34, 1.99, -1.39, -1.46, -0.85, 3.44, 0.04 };
	public static double Z5[] = { 1.30, -2.65, 0.75, -0.25, -0.62, -0.38, 0.09, 0.26, 0.31, 0.84, -0.98, 1.61, 2.00, 0.66, -0.17, 0.67, -0.40, -0.02, -1.59, -1.47 };
	public static double ALL_CONSTANTS[][] = { AGE, FLEX, FREQK, HPATHY, HPHOB, HELIX, MUTAB, GRNTHM, ASA, TAYLOR, VOLUME, Z1, Z2, Z3, Z4, Z5 };

	public static final String[] aminoAcidsInTaylorOrder = {"D", "S", "T", "G", "P", "C", "A", "V", "I", "L", "M", "F", "Y", "W", "H", "R", "K", "N", "Q", "E"};

	public static final Color[] aminoAcidTaylorColors = {new Color(255, 0, 0),
												 		 new Color(255, 51, 0),
														 new Color(255, 102, 0),
														 new Color(255, 153, 0),
														 new Color(255, 204, 0),
														 new Color(255, 255, 0),
														 new Color(204, 255, 0),
														 new Color(153, 255, 0),
														 new Color(102, 255, 0),
														 new Color(51, 255, 0),
														 new Color(0, 255, 0),
														 new Color(0, 255, 102),
														 new Color(0, 255, 204),
														 new Color(0, 204, 255),
														 new Color(0, 102, 255),
														 new Color(0, 0, 255),
														 new Color(102, 0, 255),
														 new Color(204, 0, 255),
														 new Color(255, 0, 204),
														 new Color(255, 0, 102)};

	public static final HashMap<String, Color> aaColorMaps = new HashMap<String, Color>();

	static
	{
		for(int i = 0; i < aminoAcidsInTaylorOrder.length; i++)
			aaColorMaps.put(aminoAcidsInTaylorOrder[i], aminoAcidTaylorColors[i]);
	}


	public static String[] AMINO_ACID_MATRIX_NAMES = {"A",  "R",  "N",  "D",  "C",  "Q",  "E",  "G",  "H",
		"I",  "L",  "K",  "M",  "F",  "P",  "S",  "T",  "W",  "Y",  "V",  "B",  "Z",  "X",  "-"};

	public static Hashtable<String, Integer> AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES = new Hashtable<String, Integer>();
	static
	{
		for( int i = 0; i < AMINO_ACID_MATRIX_NAMES.length; i++ )
			AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.put(AMINO_ACID_MATRIX_NAMES[i], i);
	}

	public static double[][] AMINO_ACID_MATRIX =
	{{ 4, -1, -2, -2, 0, -1, -1, 0, -2, -1, -1, -1, -1, -2, -1, 1, 0, -3, -2, 0, -2, -1, 0, -4 },
	{-1, 5, 0, -2, -3, 1, 0, -2, 0, -3, -2, 2, -1, -3, -2, -1, -1, -3, -2, -3, -1, 0, -1, -4 },
	{-2, 0, 6, 1, -3, 0, 0, 0, 1, -3, -3, 0, -2, -3, -2, 1, 0, -4, -2, -3, 3, 0, -1, -4 },
	{-2, -2, 1, 6, -3, 0, 2, -1, -1, -3, -4, -1, -3, -3, -1, 0, -1, -4, -3, -3, 4, 1, -1, -4 },
	{0, -3, -3, -3, 9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4 },
	{-1, 1, 0, 0, -3, 5, 2, -2, 0, -3, -2, 1, 0, -3, -1, 0, -1, -2, -1, -2, 0, 3, -1, -4 },
	{-1, 0, 0, 2, -4, 2, 5, -2, 0, -3, -3, 1, -2, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4 },
	{0, -2, 0, -1, -3, -2, -2, 6, -2, -4, -4, -2, -3, -3, -2, 0, -2, -2, -3, -3, -1, -2, -1, -4 },
	{-2, 0, 1, -1, -3, 0, 0, -2, 8, -3, -3, -1, -2, -1, -2, -1, -2, -2, 2, -3, 0, 0, -1, -4 },
	{-1, -3, -3, -3, -1, -3, -3, -4, -3, 4, 2, -3, 1, 0, -3, -2, -1, -3, -1, 3, -3, -3, -1, -4 },
	{-1, -2, -3, -4, -1, -2, -3, -4, -3, 2, 4, -2, 2, 0, -3, -2, -1, -2, -1, 1, -4, -3, -1, -4 },
	{-1, 2, 0, -1, -3, 1, 1, -2, -1, -3, -2, 5, -1, -3, -1, 0, -1, -3, -2, -2, 0, 1, -1, -4 },
	{-1, -1, -2, -3, -1, 0, -2, -3, -2, 1, 2, -1, 5, 0, -2, -1, -1, -1, -1, 1, -3, -1, -1, -4 },
	{-2, -3, -3, -3, -2, -3, -3, -3, -1, 0, 0, -3, 0, 6, -4, -2, -2, 1, 3, -1, -3, -3, -1, -4 },
	{-1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4, 7, -1, -1, -4, -3, -2, -2, -1, -2, -4 },
	{1, -1, 1, 0, -1, 0, 0, 0, -1, -2, -2, 0, -1, -2, -1, 4, 1, -3, -2, -2, 0, 0, 0, -4 },
	{0, -1, 0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1, 1, 5, -2, -2, 0, -1, -1, 0, -4 },
	{-3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1, 1, -4, -3, -2, 11, 2, -3, -4, -3, -2, -4 },
	{-2, -2, -2, -3, -2, -1, -2, -3, 2, -1, -1, -2, -1, 3, -3, -2, -2, 2, 7, -1, -3, -2, -1, -4 },
	{0, -3, -3, -3, -1, -2, -2, -3, -3, 3, 1, -2, 1, -1, -2, -2, 0, -3, -1, 4, -3, -2, -1, -4 },
	{-2, -1, 3, 4, -3, 0, 1, -1, 0, -3, -4, 0, -3, -3, -2, 0, -1, -4, -3, -3, 4, 1, -1, -4 },
	{-1, 0, 0, 1, -3, 3, 4, -2, 0, -3, -3, 1, -1, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4 },
	{0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, 0, 0, -2, -1, -1, -1, -1, -1, -4 },
	{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1}};

	public boolean isSymbolDefined( String symbol )
	{
		if( symbol.equalsIgnoreCase("-") || symbol.equals("."))
				return true ;

		if( symbol.equalsIgnoreCase("B")
			|| symbol.equalsIgnoreCase("J")
			|| symbol.equalsIgnoreCase("O")
			|| symbol.equalsIgnoreCase("U")
			|| symbol.equalsIgnoreCase("X")
			|| symbol.equalsIgnoreCase("Z") )
			return false;

		return( AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(symbol) != null );
	}

	public static double getMatrixValue( String aa1, String aa2 )
	{
		Integer loc1 = AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa1);
		Integer loc2 = AMINO_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa2);
		if( loc1 == null )
			loc1 = AMINO_ACID_MATRIX.length - 1;
		if( loc2 == null)
			loc2 = AMINO_ACID_MATRIX.length - 1;
		return AMINO_ACID_MATRIX[loc1][loc2];
	}

	public double[] getConstantsForSymbol( int index )
	{
		double[] constants = new double[ALL_CONSTANTS.length];
		for( int i = 0; i < ALL_CONSTANTS.length; i++ )
			constants[i] = ALL_CONSTANTS[i][index];

		return constants;
	}

	public double[] getConstantsForSymbol( String aminoAcidSymbol )
	{
		for( int i = 0; i < AMINO_ACID_SYMBOLS.length; i++ )
			if( AMINO_ACID_SYMBOLS[i].equalsIgnoreCase(aminoAcidSymbol))
				return( getConstantsForSymbol(i) );

		return null;
	}

	public String[] getNames()
	{
		return AMINO_ACID_NAMES;
	}

	public String[] getSymbols()
	{
		return AMINO_ACID_SYMBOLS;
	}

	public String[] getSortTypes()
	{
		return SORT_TYPES;
	}
}
