package jprofilegrid.constants;

import java.util.Hashtable;

public class DNAConstants extends AlignmentConstants
{
	public static String NUCLEIC_ACID_NAMES[] = { "ade", "cyt", "gua", "thy", "gap" };
	public static String NUCLEIC_ACID_SYMBOLS[] = { "A", "C", "G", "T", "." };

	public static String SORT_TYPES[] = {  "Alphabetical-Code", "Alphabetical-Name" };

	public static String[] NUCLEIC_ACID_MATRIX_NAMES = {"A", "T", "G", "C"};/*, "S", "W",
		"R", "Y", "K", "M", "B", "V", "H", "D", "N"};*/

	public static Hashtable<String, Integer> NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES = new Hashtable<String, Integer>();
	static
	{
		for( int i = 0; i < NUCLEIC_ACID_MATRIX_NAMES.length; i++ )
			NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.put(NUCLEIC_ACID_MATRIX_NAMES[i], i);
	}

	public static double[][] NUCLEIC_ACID_MATRIX =
		{{5,-4,-4,-4,-4, 1, 1,-4,-4, 1,-4,-1,-1,-1,-2},
		{-4, 5,-4,-4,-4, 1,-4, 1, 1,-4,-1,-4,-1,-1,-2},
		{-4,-4, 5,-4, 1,-4, 1,-4, 1,-4,-1,-1,-4,-1,-2},
		{-4,-4,-4, 5, 1,-4,-4, 1,-4, 1,-1,-1,-1,-4,-2},
		{-4,-4, 1, 1,-1,-4,-2,-2,-2,-2,-1,-1,-3,-3,-1},
		{ 1, 1,-4,-4,-4,-1,-2,-2,-2,-2,-3,-3,-1,-1,-1},
		{ 1,-4, 1,-4,-2,-2,-1,-4,-2,-2,-3,-1,-3,-1,-1},
		{-4, 1,-4, 1,-2,-2,-4,-1,-2,-2,-1,-3,-1,-3,-1},
		{-4, 1, 1,-4,-2,-2,-2,-2,-1,-4,-1,-3,-3,-1,-1},
		{ 1,-4,-4, 1,-2,-2,-2,-2,-4,-1,-3,-1,-1,-3,-1},
		{-4,-1,-1,-1,-1,-3,-3,-1,-1,-3,-1,-2,-2,-2,-1},
		{-1,-4,-1,-1,-1,-3,-1,-3,-3,-1,-2,-1,-2,-2,-1},
		{-1,-1,-4,-1,-3,-1,-3,-1,-3,-1,-2,-2,-1,-2,-1},
		{-1,-1,-1,-4,-3,-1,-1,-3,-1,-3,-2,-2,-2,-1,-1},
		{-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}};

	public boolean isSymbolDefined( String symbol )
	{
		if( symbol.equalsIgnoreCase("-") || symbol.equalsIgnoreCase("."))
				return true ;

		return( NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(symbol) != null );
	}

	public static double getMatrixValue( String aa1, String aa2 )
	{
		Integer loc1 = NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa1);
		Integer loc2 = NUCLEIC_ACID_MATRIX_SYMBOLS_TO_INDICES.get(aa2);
		if( loc1 == null )
			loc1 = NUCLEIC_ACID_MATRIX.length - 1;
		if( loc2 == null)
			loc2 = NUCLEIC_ACID_MATRIX.length - 1;
		return NUCLEIC_ACID_MATRIX[loc1][loc2];
	}

	public double[] getConstantsForSymbol( int index )
	{
	/*	double[] constants = new double[ALL_CONSTANTS.length];
		for( int i = 0; i < ALL_CONSTANTS.length; i++ )
			constants[i] = ALL_CONSTANTS[i][index];
	*/
		return (new double[0]);
	}

	public double[] getConstantsForSymbol( String nucleicAcidSymbol )
	{
		for( int i = 0; i < NUCLEIC_ACID_SYMBOLS.length; i++ )
			if( NUCLEIC_ACID_SYMBOLS[i].equalsIgnoreCase(nucleicAcidSymbol))
				return( getConstantsForSymbol(i) );

		return null;
	}

	public String[] getNames()
	{
		return NUCLEIC_ACID_NAMES;
	}

	public String[] getSymbols()
	{
		return NUCLEIC_ACID_SYMBOLS;
	}

	public String[] getSortTypes()
	{
		return SORT_TYPES;
	}
}
