package jprofilegrid.constants;

import java.util.PriorityQueue;

import jprofilegrid.calculations.Symbol;

public class SortedAminoAcidNamesAndSymbols
{
	private String sortedAminoAcidNames[];
	private String sortedAminoAcidSymbols[];
	private String sortType;

	public SortedAminoAcidNamesAndSymbols( String[] nSortedAminoAcidNames,
			String[] nSortedAminoAcidSymbols, String nSortType )
	{
		sortedAminoAcidNames = nSortedAminoAcidNames;
		sortedAminoAcidSymbols = nSortedAminoAcidSymbols;
		sortType = nSortType;
	}

	public static SortedAminoAcidNamesAndSymbols sort(int nSortType, boolean ascending, AlignmentConstants alignmentConstants)
	{
		String[] unsortedNames   = alignmentConstants.getNames();
		String[] unsortedSymbols = alignmentConstants.getSymbols();

		// If a sort has been requested, then perform the sort else
		// initialize aminoAcidNames and aminoAcidSymbols in
		// alphabetical order.
		String sortType;
		if( nSortType == 0 )
			sortType = "Alpha-Code";
		else
			if(nSortType == 1)
				sortType = "Alpha-Name";
			else
				sortType = unsortedNames[nSortType - 2];

		int lastName = unsortedNames.length - 1;

		String[] sortedAminoAcidNames   = new String[unsortedNames.length];
		String[] sortedAminoAcidSymbols = new String[unsortedNames.length];

		PriorityQueue<Symbol> sortedAAs = new PriorityQueue<Symbol>();
		for( int i = 0; i < lastName; i++ )
			sortedAAs.add( new Symbol(unsortedNames[i], unsortedSymbols[i], alignmentConstants.getConstantsForSymbol(i), nSortType, ascending ));

		for( int i = 0; i < lastName; i++ )
		{
			Symbol currentAA = sortedAAs.poll();

			sortedAminoAcidNames[i]   = currentAA.getName();
			sortedAminoAcidSymbols[i] = currentAA.getSymbol();
		}

		sortedAminoAcidNames[lastName]   = unsortedNames[lastName];
		sortedAminoAcidSymbols[lastName] = unsortedSymbols[lastName];

		return new SortedAminoAcidNamesAndSymbols(sortedAminoAcidNames, sortedAminoAcidSymbols, sortType);
	}

	public String[] getSortedAminoAcidNames()
	{
		return sortedAminoAcidNames;
	}

	public String[] getSortedAminoAcidSymbols()
	{
		return sortedAminoAcidSymbols;
	}

	public String getSortType()
	{
		return sortType;
	}
}
