package jprofilegrid.model;

import java.util.ArrayList;
import java.util.List;

import jprofilegrid.calculations.ResidueFrequencyCount;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.constants.AlignmentConstants;
import jxl.format.Colour;

public class AnalysisOptions
{
    public AnalysisOptions(int numberOfSequences)
    {
        sequenceIndicesInMSA = new ArrayList<Integer>();
        for(int i = 0; i < numberOfSequences; i++)
            sequenceIndicesInMSA.add(i);
    }

    public List<Integer> sequenceIndicesInMSA;

    public boolean regExFilteringEnabled = false,
                      metaDataFilteringEnabled = false,
                      selectionFilteringEnabled = false,
                      referenceSequenceChanged = false,
                      skipGaps = false,
                      skipGapsChanged = false,
                      positionRowStartChanged = false,
                      sortAscending = true,
                      sortAscendingChanged = false,
                      recalculateSorting = true,
                      showValuesAsChanged = false,
                      highlightSequenceChanged = false,
                      highlightSequenceColourChanged = false,
                      highlightTypeChanged = false,
                      similarityParametersEnabled = false,
                      recalculateSimilarityParameters = false,
                      frequencyColorsEnabled = true;

    public Sequence referenceSequence,
                    highlightSequence;

    public int positionRowStart,
               sortType,
               showValuesAs,
               windowSize,
               columnsPerTier,
               firstColumn = 1,
               lastColumn,
               highlightType,
               highlightThresholdType;

    public Colour highlightSequenceColour = Colour.PINK;

    public double highlightThreshold,
                     threshold,
                     similarityFraction = 1.00;

    public String inputFilename,
                   outputFilename,
                   weightedString = "Unweighted",
                   pdbFile;

    public AlignmentConstants alignmentConstants;
    public ConservationRange conservationRange = ConservationRange.DEFAULT_CONSERVATION_RANGE;
    public ResidueFrequencyCount sortedData;
}
