package jprofilegrid.model;

import jxl.format.Colour;
import java.util.Vector;

public class ConservationRange
{
    public static final String[] COLOR_SET_NAMES = { "Blue Ramp", "Spectrum-1", "Spectrum-2", "Grayscale"};

    public static final Colour[][] COLOR_SETS =
        {
          { Colour.WHITE, Colour.LIGHT_TURQUOISE  , Colour.PALE_BLUE          , Colour.LIGHT_BLUE  , Colour.BLUE  ,Colour.DARK_BLUE  },
          { Colour.WHITE, Colour.GRAY_25, Colour.YELLOW         , Colour.ORANGE , Colour.GREEN  , Colour.RED   },
          { Colour.WHITE, Colour.GREY_40_PERCENT, Colour.LIGHT_BLUE, Colour.GREEN, Colour.ORANGE, Colour.RED   },
          { Colour.WHITE, Colour.GRAY_25, Colour.GREY_40_PERCENT, Colour.GRAY_50, Colour.GRAY_80, Colour.BLACK },
        };


    public static final Double[] DEFAULT_CONSERVATION_RANGES = { 0.0, .10, .25, .50, .70, .90 };

    public static final ConservationRange DEFAULT_CONSERVATION_RANGE = new ConservationRange(getDefaultConservationColors(),
                                                                            DEFAULT_CONSERVATION_RANGES);

    Vector<Double> range = new Vector<Double>();
    Vector<Colour> colours = new Vector<Colour>();

    public ConservationRange()
    {
    }

    public ConservationRange(Colour[] nColourRanges, Double[] nDefaultConservationRanges )
    {
        for( int i = 0; i < nColourRanges.length; i++ )
            colours.add(nColourRanges[i]);

        for( int i = 0; i < nDefaultConservationRanges.length; i++ )
            range.add(nDefaultConservationRanges[i]);
    }

    public int getNumberOfRanges()
    {
        return range.size();
    }

    public void addConservationRange( double freq, Colour colour)
    {
        range.add(freq);
        colours.add(colour);
    }

    public double getThreshold(int index)
    {
        return range.get(index);
    }

    public Colour getColour(int index)
    {
        return colours.get(index);
    }

    public static Colour[] getDefaultConservationColors()
    {
        return COLOR_SETS[0];
    }

    public Double[] getDefaultConservationRanges()
    {
        return DEFAULT_CONSERVATION_RANGES;
    }
}
