package jprofilegrid.model;

import jxl.format.Colour;
public class Format 
{
	public static int LEFT_ALIGNED = -1, CENTER_ALIGNED = 0, RIGHT_ALIGNED = 1;
	public static boolean BOLD = true, NOT_BOLD = false;
	
	private Colour backgroundColor, borderColor, fontColor;
	private boolean topBorderEnabled = false, bottomBorderEnabled = false, 
					leftBorderEnabled = false, rightBorderEnabled = false,
					bold;
	private int alignment;
	
	public Format(int nAlignment, boolean nBold)
	{
		alignment = nAlignment;
		bold = nBold;
	}
	
	public boolean isBold()
	{
		return bold;
	}
	
	public int getAlignment()
	{
		return alignment;
	}
	
	public Colour getBackgroundColor()
	{
		return( backgroundColor );
	}
	
	public Colour getBorderColor()
	{
		return( borderColor );
	}
	
	public Colour getFontColor()
	{
		return( fontColor );
	}
	
	public void setBackgroundColor( Colour nBackgroundColor )
	{
		backgroundColor = nBackgroundColor;
	}
	
	public void setBorderColor( Colour nBorderColor )
	{
		borderColor = nBorderColor;
	}
	
	public void setFontColor( Colour nFontColor )
	{
		fontColor = nFontColor;
	}
	public boolean hasTopBorder()
	{
		return( topBorderEnabled );
	}
	
	public boolean hasBottomBorder()
	{
		return( bottomBorderEnabled );
	}
	
	public boolean hasLeftBorder()
	{
		return( leftBorderEnabled );
	}
	
	public boolean hasRightBorder()
	{
		return( rightBorderEnabled );
	}
	
	public void setAlignment(int nAlignment)
	{
		alignment = nAlignment;
	}
	
	public void setTopBorderEnabled(boolean nTopBorderEnabled)
	{
		topBorderEnabled = nTopBorderEnabled;
	}
	
	public void setBottomBorderEnabled(boolean nBottomBorderEnabled)
	{
		bottomBorderEnabled = nBottomBorderEnabled;
	}
	
	public void setLeftBorderEnabled(boolean nLeftBorderEnabled)
	{
		leftBorderEnabled = nLeftBorderEnabled;
	}
	
	public void setRightBorderEnabled(boolean nRightBorderEnabled)
	{
		rightBorderEnabled = nRightBorderEnabled;
	}
}
