package jprofilegrid.model;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import jprofilegrid.writers.PyMOLScriptWriter;
import jxl.Workbook;

public class ProfileGrid
{
    private String inputFile;
    private Tier entireAlignment;
    private String[] sortedAminoAcidNames, sortedAminoAcidSymbols;
    private int numberOfVariableRegions, numberOfMotifRegions, numberOfSequences;
    private Text referenceSequenceName, highlightSequenceName;
    private int[] motifEndpointIndices, variableRegionEndpointIndices;
    private Vector<Double> plotSimValues;
    private Vector<UnknownSymbol> unknownSymbols;

    private AnalysisOptions analysisOptions;

    public ProfileGrid(int numberOfSequences)
    {
        analysisOptions = new AnalysisOptions(numberOfSequences);
    }

    public Tier getVariableRegion( int variableRegionNumber )
    {
        return(getEntireAlignment().subTier(getVariableRegionEndpointIndices()[2 * variableRegionNumber],
                getVariableRegionEndpointIndices()[2 * variableRegionNumber + 1] + 1));
    }

    public Tier getMotifRegion( int motifRegionNumber )
    {
        return(getEntireAlignment().subTier(getMotifEndpointIndices()[2 * motifRegionNumber],
                getMotifEndpointIndices()[2 * motifRegionNumber + 1] + 1));
    }

    public Tier getEntireAlignment()
    {
        return entireAlignment;
    }

    public Tier getTier( int startCol, int endCol )
    {
        return getEntireAlignment().subTier(startCol, endCol);
    }

    public int getSequenceLength()
    {
        return getEntireAlignment().getAminoAcidCounts().length;
    }

    public String[] getSortedAminoAcidNames()
    {
        return sortedAminoAcidNames;
    }

    public String[] getSortedAminoAcidSymbols()
    {
        return sortedAminoAcidSymbols;
    }

    public void setAnalysisOptions(AnalysisOptions analysisOptions)
    {
        this.analysisOptions = analysisOptions;
    }

    public AnalysisOptions getAnalysisOptions()
    {
        return analysisOptions;
    }

    public void outputExcelFile()
    {
        try
        {
            String filename = analysisOptions.outputFilename;
            int columnsPerTier = analysisOptions.columnsPerTier;

            jprofilegrid.writers.ExcelFileWriter writer = new jprofilegrid.writers.ExcelFileWriter( Workbook.createWorkbook(
                    new File(filename)), this);

            writer.writeExcelFile(columnsPerTier, analysisOptions.firstColumn - 1, analysisOptions.lastColumn - 1);
        }
        catch(IOException e)
        {
        }
    }

    public void outputPyMOLScript()
    {
        String filename = analysisOptions.outputFilename;
        int firstColumn = analysisOptions.firstColumn;
        int lastColumn  = analysisOptions.lastColumn;
        String pdbFile  = analysisOptions.pdbFile;
        if(pdbFile == null) pdbFile = "filename.pdb";
        PyMOLScriptWriter.outputPyMOLScript(this, analysisOptions, getInputFile(), filename, pdbFile, firstColumn, lastColumn);
    }

    public void setInputFile(String inputFile)
    {
        this.inputFile = inputFile;
    }

    public String getInputFile()
    {
        return inputFile;
    }

    public void setEntireAlignment(Tier entireAlignment)
    {
        this.entireAlignment = entireAlignment;
    }

    public void setSortedAminoAcidNames(String[] sortedAminoAcidNames)
    {
        this.sortedAminoAcidNames = sortedAminoAcidNames;
    }

    public void setSortedAminoAcidSymbols(String[] sortedAminoAcidSymbols)
    {
        this.sortedAminoAcidSymbols = sortedAminoAcidSymbols;
    }

    public void setReferenceSequenceName(Text referenceSequenceName)
    {
        this.referenceSequenceName = referenceSequenceName;
    }

    public Text getReferenceSequenceName()
    {
        return referenceSequenceName;
    }

    public void setHighlightSequenceName(Text highlightSequenceName)
    {
        this.highlightSequenceName = highlightSequenceName;
    }

    public Text getHighlightSequenceName()
    {
        return highlightSequenceName;
    }

    public void setMotifEndpointIndices(int[] motifEndpointIndices)
    {
        this.motifEndpointIndices = motifEndpointIndices;
    }

    public int[] getMotifEndpointIndices()
    {
        return motifEndpointIndices;
    }

    public void setVariableRegionEndpointIndices(
            int[] variableRegionEndpointIndices)
    {
        this.variableRegionEndpointIndices = variableRegionEndpointIndices;
    }

    public int[] getVariableRegionEndpointIndices()
    {
        return variableRegionEndpointIndices;
    }

    public void setNumberOfVariableRegions(int numberOfVariableRegions)
    {
        this.numberOfVariableRegions = numberOfVariableRegions;
    }

    public int getNumberOfVariableRegions()
    {
        return numberOfVariableRegions;
    }

    public void setNumberOfMotifRegions(int numberOfMotifRegions)
    {
        this.numberOfMotifRegions = numberOfMotifRegions;
    }

    public int getNumberOfMotifRegions()
    {
        return numberOfMotifRegions;
    }

    public void setUnknownSymbols(Vector<UnknownSymbol> unknownSymbols)
    {
        this.unknownSymbols = unknownSymbols;
    }

    public Vector<UnknownSymbol> getUnknownSymbols()
    {
        return unknownSymbols;
    }

    public void setPlotSimValues(Vector<Double> plotSimValues)
    {
        this.plotSimValues = plotSimValues;
    }

    public Vector<Double> getPlotSimValues()
    {
        return plotSimValues;
    }

    public void setNumberOfSequences(int numberOfSequences)
    {
        this.numberOfSequences = numberOfSequences;
    }

    public int getNumberOfSequences()
    {
        return numberOfSequences;
    }
}
