package jprofilegrid.model;

import jprofilegrid.constants.AlignmentConstants;

public class Tier
{
	private Text[] majorAminoAcidRow, templateSequenceRow, positionInAlignmentRow, motiffNumberingRow,
				   highlightSequenceRow, highlightSequenceArray;
	private Cell[][] aminoAcidCounts;
	private static Text totalCountsString = new Text( new Format(Format.CENTER_ALIGNED, Format.BOLD), "Counts" ),
						totalFrequenciesString = new Text( new Format(Format.CENTER_ALIGNED, Format.BOLD), "Freq.");
	private Numeric[] totalAminoAcidCounts, totalAminoAcidFrequencies;
	private AlignmentConstants constants;
	private int[][] integerAminoAcidCounts;
	private int[] positionInAlignmentRowWithoutSkippingGaps;

	/*
	 * A 'Tier' is defined as one block of the profile grid
	 * that starts and ends with the amino-acid names (or symbols) column.
	 * The Tier class holds all of the information between these two columns.
	 */
	public Tier( Text[] nPositionInAlignmentRow, Text[] nMotiffNumberingRow,
			Text[] nMajorAminoAcidRow, Text[] nComparisonSequenceRow, Cell[][] nAminoAcidCounts,
			AlignmentConstants nConstants, int[][] nIntegerAminoAcidCounts,
			int[] nPositonInAlignmentRowWithoutSkippingGaps,
			Text[] nHighlightSequenceArray)
	{
		positionInAlignmentRow = nPositionInAlignmentRow;
		motiffNumberingRow = nMotiffNumberingRow;
		majorAminoAcidRow = nMajorAminoAcidRow;
		templateSequenceRow = nComparisonSequenceRow;
		aminoAcidCounts = nAminoAcidCounts;
		constants = nConstants;
		integerAminoAcidCounts = nIntegerAminoAcidCounts;
		positionInAlignmentRowWithoutSkippingGaps = nPositonInAlignmentRowWithoutSkippingGaps;
		highlightSequenceArray = nHighlightSequenceArray;
	}

	public int[][] getIntegerAminoAcidCounts()
	{
		return integerAminoAcidCounts;
	}

	public int[] getPositonInAlignmentRowWithoutSkippingGaps()
	{
		return positionInAlignmentRowWithoutSkippingGaps;
	}


	/*
	 * Accessor methods.
	 */

	public void setHighlightSequenceRow(Text[] nHighlightSequenceRow)
	{
		highlightSequenceRow = nHighlightSequenceRow;
	}

	public Numeric[] getTotalAminoAcidCounts()
	{
		return totalAminoAcidCounts;
	}

	public Numeric[] getTotalAminoAcidFrequencies()
	{
		return totalAminoAcidFrequencies;
	}

	public Text[] getMajorAminoAcidRow()
	{
		return majorAminoAcidRow;
	}

	public Text[] getReferenceSequenceRow()
	{
		return templateSequenceRow;
	}

	public Text[] getPositionInAlignmentRow()
	{
		return positionInAlignmentRow;
	}

	public Text[] getMorphNumberingRow()
	{
		return motiffNumberingRow;
	}

	public Text[] getHighlightSequenceRow()
	{
		return highlightSequenceRow;
	}

	public Text[] getHighlightSequenceArray()
	{
		return highlightSequenceArray;
	}

	public Cell[][] getAminoAcidCounts()
	{
		return aminoAcidCounts;
	}

	public Text getTotalCountsString()
	{
		return totalCountsString;
	}

	public Text getTotalFequenciesString()
	{
		return totalFrequenciesString;
	}

	public Tier subTier( int startCol, int endCol )
	{
		int lengthOfTier = endCol - startCol;
		Text[] nMajorAminoAcidRow = new Text[lengthOfTier],
			   nComparisonSequenceRow = new Text[lengthOfTier];
		Text[] nPositionInAlignmentRow = new Text[lengthOfTier],
				  nMotiffNumberingRow = new Text[lengthOfTier],
			   nHighlightSequenceRow = new Text[lengthOfTier],
			   nHighlightSequenceArray = new Text[lengthOfTier];
		Cell[][] nAminoAcidCounts = new Cell[lengthOfTier][aminoAcidCounts.length];
		int[][] nIntegerAminoAcidCounts = new int[lengthOfTier][aminoAcidCounts.length];
		int[] nPositionInAlignmentRowWithoutSkippingGaps = new int[lengthOfTier];
		for( int i = startCol; i < endCol; i++ )
		{
			nMajorAminoAcidRow[i - startCol] = majorAminoAcidRow[i];
			nComparisonSequenceRow[i - startCol] = templateSequenceRow[i];
			nPositionInAlignmentRow[i - startCol] = positionInAlignmentRow[i];
			nMotiffNumberingRow[i - startCol] = motiffNumberingRow[i];
			nAminoAcidCounts[i - startCol] = aminoAcidCounts[i];
			nIntegerAminoAcidCounts[i - startCol] = integerAminoAcidCounts[i];
			nHighlightSequenceRow[i - startCol] = highlightSequenceRow[i];
			nPositionInAlignmentRowWithoutSkippingGaps[i - startCol] = positionInAlignmentRowWithoutSkippingGaps[i];
			nHighlightSequenceArray[i - startCol] = highlightSequenceArray[i];
		}

		Tier nTier = new Tier( nPositionInAlignmentRow, nMotiffNumberingRow, nMajorAminoAcidRow, nComparisonSequenceRow,
				nAminoAcidCounts, constants, nIntegerAminoAcidCounts, nPositionInAlignmentRowWithoutSkippingGaps,
				nHighlightSequenceArray);

		nTier.setHighlightSequenceRow(nHighlightSequenceRow);

		return( nTier );
	}
}
