package jprofilegrid.model;
import java.util.Vector;
public class UnknownSymbol 
{
	private String symbol;
	
	Vector<UnknownSymbolSpecies> sAndL = new Vector<UnknownSymbolSpecies>();
	
	public UnknownSymbol( String nSymbol, String species, int location )
	{
		symbol = nSymbol;
		sAndL.add(new UnknownSymbolSpecies(species, location));
	}
	
	public void addUnknownSymbolSpeciesAndLocation(String species, int location )
	{
		for( int i = 0; i < sAndL.size(); i++ )
		{
			if( sAndL.get(i).getSpecies().equalsIgnoreCase(species))
			{
				sAndL.get(i).addLocation(location);
				return;
			}
		}
		sAndL.add(new UnknownSymbolSpecies(species, location));
	}
	
	public UnknownSymbolSpecies getUnknownSymbolSpeciesAndLocation(int index)
	{
		return sAndL.get(index);
	}
	
	public int getNumberOfSpecies()
	{
		return sAndL.size();
	}
	
	public String getSymbol()
	{
		return(symbol);
	}
}
