package jprofilegrid.presenter;

import java.util.Iterator;
import java.util.PriorityQueue;

import jxl.format.Colour;
import jxl.format.RGB;

public class ColorManager
{
	private static Colour[] SORTED_COLOURS;
	private static String[] SORTED_COLOUR_NAMES;

	static
	{
		initializeSortedColours();
		initializeSortedColourNames();
	}

	public static Colour[] getSortedColours()
	{
		return SORTED_COLOURS;
	}

	public static String[] getSortedColourNames()
	{
		return SORTED_COLOUR_NAMES;
	}

	public static void initializeSortedColours()
	{
		ColorPriorityQueue allColors = new ColorPriorityQueue();
		allColors.add(new ColorSorter(Colour.BLACK));
		allColors.add(new ColorSorter(Colour.GRAY_80));

		for( int i = 0xa, j = 0; i < 0x3f; i++, j++ )
			if( i != 0x14)
				if(allColors.doesNotContain((new ColorSorter(Colour.getInternalColour(i)))))
					allColors.add(new ColorSorter(Colour.getInternalColour(i)));

		allColors.add(new ColorSorter(Colour.WHITE));
		SORTED_COLOURS = new Colour[allColors.size()];
		for( int i = 0; i < SORTED_COLOURS.length; i++)
			SORTED_COLOURS[i] = allColors.remove().getColour();
	}

	private static void initializeSortedColourNames()
	{
		ColorPriorityQueue allColors = new ColorPriorityQueue();

		allColors.add(new ColorSorter(Colour.BLACK));
		allColors.add(new ColorSorter(Colour.WHITE));
		allColors.add(new ColorSorter(Colour.GRAY_80));
		for( int i = 0xa, j = 0; i < 0x3f; i++, j++ )
			if(allColors.doesNotContain(new ColorSorter(Colour.getInternalColour(i))))
				allColors.add(new ColorSorter(Colour.getInternalColour(i)));

		SORTED_COLOUR_NAMES = new String[allColors.size()];
		for( int i = 0; i < SORTED_COLOUR_NAMES.length; i++)
			SORTED_COLOUR_NAMES[i] = allColors.remove().getColour().getDescription();
	}

	public static int getColorIndexWithName(String name)
	{
		for( int i = 0; i < SORTED_COLOURS.length; i++ )
			if( name.equalsIgnoreCase(SORTED_COLOURS[i].getDescription()) )
				return i;

		return -1;
	}

	private static class ColorPriorityQueue extends PriorityQueue<ColorSorter>
	{
		private static final long serialVersionUID = 8634045462607950274L;

		public boolean doesNotContain(ColorSorter otherColour)
		{
			Iterator<ColorSorter> it = iterator();
			while(it.hasNext())
				if(it.next().getColour().getDescription().equalsIgnoreCase(otherColour.getColour().getDescription()))
					return false;

			return true;
		}
	}

	private static class ColorSorter implements Comparable<ColorSorter>
	{
		private Colour thisColor;

		public ColorSorter(Colour nColour)
		{
			thisColor = nColour;
		}
		public int compareTo(ColorSorter color)
		{
			RGB thisRGB = thisColor.getDefaultRGB();
			RGB thatRGB = color.getColour().getDefaultRGB();

			if( thisRGB.getGreen() > thatRGB.getGreen())
				return -1;
			if(thisRGB.getGreen() < thatRGB.getGreen() )
				return 1;

			if( thisRGB.getRed() > thatRGB.getRed())
				return -1;
			if(thisRGB.getRed() < thatRGB.getRed() )
				return 1;

			if( thisRGB.getBlue() > thatRGB.getBlue())
				return -1;
			if(thisRGB.getBlue() <= thatRGB.getBlue() )
				return 1;

			return 0;
		}

		public Colour getColour()
		{
			return thisColor;
		}
	}
}
