package jprofilegrid.presenter;

import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.model.AnalysisOptions;

public class SequenceFilter
{
	public boolean regexFilter(MultipleSequenceAlignment multipleSequenceAlignment, String speciesNameFilter, String sequenceNameFilter)
	{
		boolean atLeastOneSequencePassedFilter = false;

		Pattern sequenceNameMatcher = Pattern.compile(speciesNameFilter),
				speciesNameMatcher	= Pattern.compile(sequenceNameFilter);

		List<Sequence> sequences = multipleSequenceAlignment.getSequences();
		for(Sequence sequence : sequences)
		{
			if( sequenceNameMatcher.matcher(sequence.getName()).find() &&
				speciesNameMatcher.matcher(sequence.getSequence()).find() )
			{
				sequence.setSequenceNamePassedRegexFilter(true);
				atLeastOneSequencePassedFilter = true;
			}
			else
				sequence.setSequenceNamePassedRegexFilter(false);
		}

		return atLeastOneSequencePassedFilter;
	}

	public boolean nameListFilter(MultipleSequenceAlignment multipleSequenceAlignment, List<String> matchingSequences)
	{
		boolean atLeastOneSequencePassedFilter = false;

		List<Sequence> sequences = multipleSequenceAlignment.getSequences();
		for(Sequence sequence : sequences)
		{
			if(matchingSequences.contains(sequence.getName()))
			{
				sequence.setSequencePassedMetaDataFilter(true);
				atLeastOneSequencePassedFilter = true;
			}
			else
				sequence.setSequencePassedMetaDataFilter(false);
		}

		return atLeastOneSequencePassedFilter;
	}

	public static SelectionFilterResults selectionFilter(int row, int col,
								MultipleSequenceAlignment multipleSequenceAlignment,
								AnalysisOptions analysisOptions,
								boolean displayResidueIfPresent,
								boolean showAlignment,
								int startIndex)
	{
		StringBuffer listOfSequences = new StringBuffer();

		String currentSymbol = analysisOptions.sortedData.getSortedAminoAcidSymbols()[row];
		boolean currentSymbolIsGap = (currentSymbol.equalsIgnoreCase(".") || currentSymbol.equalsIgnoreCase("-"));

		List<Sequence> sequences = multipleSequenceAlignment.getSequences();

		Vector<Sequence> alignmentSequences = new Vector<Sequence>();

		alignmentSequences.add(analysisOptions.referenceSequence);
		if(analysisOptions.referenceSequence != analysisOptions.highlightSequence)
			alignmentSequences.add(analysisOptions.highlightSequence);

		for(int i = 0; i < sequences.size(); i++)
		{
			Sequence sequence = sequences.get(i);
			String comparisonSymbol = sequence.getAminoAcid(col);
			boolean comparisonSymbolIsGap = comparisonSymbol.equalsIgnoreCase("-") || comparisonSymbol.equalsIgnoreCase(".");

			if(displayResidueIfPresent)
			{
				if(comparisonSymbol.equalsIgnoreCase(currentSymbol) || (currentSymbolIsGap && comparisonSymbolIsGap))
				{
					listOfSequences = listOfSequences.append(sequence.getName().concat("\n"));
					if(showAlignment)
						alignmentSequences.add(sequence);
					sequence.setSequencePassedSelectionFilter(true);
				}
				else
					sequence.setSequencePassedSelectionFilter(false);
			}
			else
			{
				if(!(comparisonSymbol.equalsIgnoreCase(currentSymbol) || (currentSymbolIsGap && comparisonSymbolIsGap)))
				{
					listOfSequences = listOfSequences.append(sequence.getName().concat("\n"));
					if(showAlignment)
						alignmentSequences.add(sequence);
					sequence.setSequencePassedSelectionFilter(true);
				}
				else
					sequence.setSequencePassedSelectionFilter(false);
			}
		}

		// Alignment window calculation.
		StringBuilder sequenceNames = new StringBuilder("\n"),
					  alignment = new StringBuilder("");

		if(showAlignment)
		{
			// Populate the sequence names.
			for( int i = 0; i < alignmentSequences.size(); i++ )
				sequenceNames.append(alignmentSequences.get(i).getName() + "\n");

			// Calculate the longest sequence.
			int maxSequenceLength = 0;
			for( int i = 0; i < alignmentSequences.size(); i++ )
				if(alignmentSequences.get(i).getActualLength() > maxSequenceLength)
					maxSequenceLength = i;

			for( int i = startIndex; i < alignmentSequences.get(maxSequenceLength).getActualLength(); i++ )
				if( i % 10 == 0 )
				{
					alignment.append(i);
					i += (Integer.toString(i).length() - 1);
				}
				else
					alignment.append(" ");

			alignment.append("\n");

			// Build the alignment.
			for( int i = 0; i < alignmentSequences.size(); i++ )
			{
				if( i == 0 )
					alignment.append(alignmentSequences.get(0).getSequence() + "\n");
				else
				{
					// Filter for same residue as the reference at each column location.
					StringBuffer currentSequenceString = new StringBuffer("");
					int sequenceCounter = 0;
					while( sequenceCounter < alignmentSequences.get(i).getActualLength() &&
						   sequenceCounter < alignmentSequences.get(0).getActualLength() )
					{
						if( !alignmentSequences.get(i).getAminoAcid(sequenceCounter).equalsIgnoreCase("-") && alignmentSequences.get(i).getAminoAcid(sequenceCounter).equalsIgnoreCase(alignmentSequences.get(0).getAminoAcid(sequenceCounter)) )
							currentSequenceString.append(".");
						else
							currentSequenceString.append(alignmentSequences.get(i).getAminoAcid(sequenceCounter));

						sequenceCounter++;
					}

					if( sequenceCounter < alignmentSequences.get(i).getActualLength() )
						for( int j = sequenceCounter; j < alignmentSequences.get(i).getActualLength(); j++)
							currentSequenceString.append(alignmentSequences.get(i).getAminoAcid(j));
					alignment.append(currentSequenceString);
					if( i < alignmentSequences.size() - 1 )
						alignment.append("\n");
				}
			}
		}

		SelectionFilterResults selectionFilterResults = new SelectionFilterResults();
		selectionFilterResults.setAlignmentSequences(alignmentSequences);
		selectionFilterResults.setListOfSequences(listOfSequences);
		selectionFilterResults.setSequenceNames(sequenceNames);
		selectionFilterResults.setAlignment(alignment);

		return selectionFilterResults;
	}
}
