package jprofilegrid.presenter;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.MultipleSequenceAnalysis;
import jprofilegrid.model.AnalysisOptions;

public class SimilarityParametersWorker implements Runnable
{
	private MultipleSequenceAlignment multipleSequenceAlignment;
	private AnalysisOptions analysisOptions;
	private SimilarityParametersWorkerCallback similarityParametersWorkerCallback;

	public interface SimilarityParametersWorkerCallback
	{
		public void onSimilarityParametersComputed();
	}

	public SimilarityParametersWorker(MultipleSequenceAlignment multipleSequenceAlignment,
			 						  AnalysisOptions analysisOptions,
									  SimilarityParametersWorkerCallback similarityParametersWorkerCallback)
	{
		this.multipleSequenceAlignment = multipleSequenceAlignment;
		this.analysisOptions = analysisOptions;
		this.similarityParametersWorkerCallback = similarityParametersWorkerCallback;
		new Thread(this).start();
	}

	@Override
	public void run()
	{
		MultipleSequenceAnalysis.analyze(multipleSequenceAlignment, analysisOptions);
		similarityParametersWorkerCallback.onSimilarityParametersComputed();
	}
}
