package jprofilegrid.presenter;

import jprofilegrid.calculations.Sequence;

public class SortableSequence implements Comparable<SortableSequence>
{
	private Sequence sequence;
	private int index;

	public SortableSequence(Sequence sequence, int index)
	{
		this.sequence = sequence;
		this.index = index;
	}

	@Override
	public int compareTo(SortableSequence sortableSequence)
	{
		Sequence sequence = sortableSequence.getSequence();
		return this.sequence.compareTo(sequence);
	}

	public Sequence getSequence()
	{
		return sequence;
	}

	public int getIndex()
	{
		return index;
	}
}