package jprofilegrid.readers;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;

public class FASTAFileReader
{
	public static MultipleSequenceAlignment readAlignedFasta(List<String> data)
	{
		Hashtable <String, Integer> sequenceIndicesByName = new Hashtable<String, Integer>();
		Vector <Sequence> sequences = new Vector<Sequence>();

		String currentName = "";
		String currentSequence = "";

		String currentLine = "";
		int index;
		for(index = 0; index < data.size() && !currentLine.contains(">"); index++)
			currentLine = data.get(index);

		for(int j = index - 1; j < data.size(); j++)
		{
			currentLine = data.get(j);

			if(currentLine.contains(">"))
			{
				if( !currentSequence.equalsIgnoreCase(""))
				{
					String actualName = "";
					for( int i = 0; i < currentName.length(); i++ )
					{
						int charValue = currentName.charAt(i);
						if(charValue == 124)
							actualName += "_";
						else
							if( ( charValue >= 48 && charValue <= 57) ||
							    (charValue >= 65 && charValue <= 90) ||
							    (charValue >= 97 && charValue <= 122) ||
							    charValue == (int)'_')
							    actualName += currentName.substring(i, i + 1);
							else
								i = currentName.length();
					}

					sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1));
					sequenceIndicesByName.put(actualName, sequences.size() - 1 );
				}
				currentName = currentLine.replaceFirst(">", "");
				currentSequence = "";
			}
			else
				currentSequence += currentLine;
		}

		String actualName = "";
		for( int i = 0; i < currentName.length(); i++ )
		{
			int charValue = currentName.charAt(i);
			if( ( charValue >= 48 && charValue <= 57) ||
			    (charValue >= 65 && charValue <= 90) ||
			    (charValue >= 97 && charValue <= 122) || charValue == (int)'_' )
			    actualName += currentName.substring(i, i + 1);
			else
				i = currentName.length();
		}

		sequences.add(new Sequence(actualName, currentSequence, currentSequence.length(), 0, 1));
		sequenceIndicesByName.put(actualName, sequences.size() - 1 );

		return( new MultipleSequenceAlignment( null, sequences));
	}
}
