package jprofilegrid.readers;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;


public class MSFFileReader
{
	public static MultipleSequenceAlignment readInMultipleSequenceAlignment(List<String> data)
	{
		try
		{
			List <String> allData = new LinkedList<String>();
			boolean finishedHeaderSection = false;
			boolean finishedNamesSection = false;

			String currentLine;
			for(int i = 0; i < data.size(); i++)
			{
				currentLine = data.get(i);

				if( !currentLine.contains("#"));
				{
					if( currentLine.contains("//"))
						finishedNamesSection = true;
					StringTokenizer stringTokenizer = new StringTokenizer( currentLine );
					String previousString = "";
					String currentString = "";
					while(stringTokenizer.hasMoreTokens())
					{
						currentString = stringTokenizer.nextToken();
						if( !finishedHeaderSection )
							allData.add(currentString);
						else
							if( !finishedNamesSection )
							{
								if( currentString.compareTo("Name:") != 0 &&
									currentString.compareTo("Len:") != 0 &&
									currentString.compareTo("Check:") != 0 &&
									currentString.compareTo("Weight:") != 0 )
									//allData.add( currentString );
									if( previousString.compareTo("Name:") == 0 ||
									previousString.compareTo("Len:") == 0 ||
									previousString.compareTo("Check:") == 0 ||
									previousString.compareTo("Weight:") == 0 )
										allData.add( currentString );
							}
							else
								allData.add(currentString);

						previousString = currentString;

					}

					if( currentLine.contains("MSF:") )
						finishedHeaderSection = true;
				}
			}

			return( new MultipleSequenceAlignment(computeHeaderInformation(allData), computeSequenceInformation(allData)));
		}
		catch(NullPointerException e)
		{
		}
		catch(NumberFormatException e)
		{
		}

		return null;
	}

	private static LinkedList <String> computeHeaderInformation(List <String> allData)
	{
		LinkedList <String> header = new LinkedList<String>();
		boolean done = false;
		for(int i = 0; i < allData.size() && !done ; i++ )
		{
			String currentString = allData.remove(0);
			if( currentString.compareTo("..") != 0)
			{
				header.add( currentString );
			}
			else
				done = true;
		}
		return( header );
	}

	private static List<Sequence> computeSequenceInformation(List <String> allData)
	{
		Hashtable<String, Integer> sequenceIndices = new Hashtable<String, Integer>();
		Vector <Sequence> sequences = new Vector<Sequence>();
		boolean identifedAllSpecies = false;
		int speciesCounter = 0;
		while( !identifedAllSpecies )
		{
			String currentString = allData.remove(0);
			if( currentString.compareTo("//") != 0 )
			{
				String species = currentString;
				int length = Integer.parseInt(allData.remove(0));
				int check = Integer.parseInt(allData.remove(0));
				double weight = Double.parseDouble(allData.remove(0));
				sequences.add( new Sequence( species, length, check, weight) );
				sequenceIndices.put(species, speciesCounter);
				speciesCounter++;

			}
			else
				identifedAllSpecies = true;
		}

		Sequence currentSequence = null;
		while( allData.size() != 0 )
		{
			String currentEntry = allData.remove(0);
			if( sequenceIndices.containsKey(currentEntry) )
				currentSequence = sequences.get(sequenceIndices.get(currentEntry));
			else
			{
				if(currentEntry.length() > 0)
				{
					char c = currentEntry.charAt(0);

					if(c < 48 || c > 57)
						currentSequence.addToSequence( currentEntry );
				}
			}
		}

		// Check for alignment errors.
		boolean error = false;
		for( int i = 0; i < sequences.size(); i++)
		{
			if( sequences.get(i).getSequence() == null)
			{
				error = true;
				System.out.println("Species " + sequences.get(i).getName() +
						" listed in header does not have an associated sequence.");
			}
		}
		if( error )
		{
			System.out.println( "Error in alignment file, exiting.");
			System.exit(0);
		}

		return sequences;
	}
}
