package jprofilegrid.readers;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;

public class StockholmFileReader
{
	public static MultipleSequenceAlignment parseMultipleSequenceAlignment(List<String> data)
	{
		Hashtable <String, Integer> sequenceIndicesByName = new Hashtable<String, Integer>();
		Vector <Sequence> sequences = new Vector<Sequence>();

		String currentLine;
		for(int i = 0; i < data.size(); i++)
		{
			currentLine = data.get(i);

			if(currentLine.length() > 0)
			{
				char firstCharacter = currentLine.charAt(0);

				String[] nameAndSequence;
				if(firstCharacter != '#')
				{
					nameAndSequence = currentLine.split("\\s+");

					if(nameAndSequence.length == 2)
					{
						int endOfSequenceName = nameAndSequence[0].indexOf('/');

						if(endOfSequenceName == -1)
							endOfSequenceName = nameAndSequence[0].length();

						String sequenceName = nameAndSequence[0].substring(0, endOfSequenceName);
						String sequence     = nameAndSequence[1];

						if(sequenceName != null && currentLine != null)
						{
							sequences.add(new Sequence(sequenceName, sequence, sequence.length(), 0, 1));
							sequenceIndicesByName.put(sequenceName, sequences.size() - 1);
						}
					}
				}
			}
		}

		return new MultipleSequenceAlignment( null, sequences );
	}
}
