package jprofilegrid.view;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import jprofilegrid.presenter.ColorManager;
import jxl.format.Colour;
import jxl.format.RGB;

public class ColorComboBoxRenderer extends JLabel implements ListCellRenderer
{
	private static final long serialVersionUID = -2820626580393810546L;

	public ColorComboBoxRenderer()
    {
        setOpaque(true);
    }

	public Component getListCellRendererComponent( JList list,
	         Object value,
	         int index,
	         boolean isSelected,
	         boolean cellHasFocus)
	{
        setText(value.toString());
        Colour[] allAvailableColors = ColorManager.getSortedColours();
        for( int i = 0; i < allAvailableColors.length; i++ )
        {
        	if(!value.toString().equalsIgnoreCase("Load Alignment"))
        	{
	        	if( allAvailableColors[i].getDescription().equalsIgnoreCase(  ((Colour)value).getDescription() ))
	        	{
	        		setText(toTitleCase((allAvailableColors[i]).getDescription()));
	        		RGB currentColor = ((Colour)allAvailableColors[i]).getDefaultRGB();
	        		setBackground(new Color( currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue()));
					if( allAvailableColors[i].getDefaultRGB().getGreen() <  255 * .6)
						setForeground(Color.WHITE);
					else
						setForeground(Color.BLACK);
	        	}
        	}
        }
        return this;
	}

	public static String toTitleCase(String string)
	{
		String newString = "";
		boolean cap = true;
		for(int i = 0; i < string.length(); i++ )
		{
			if(cap)
				newString += String.valueOf(string.charAt(i)).toUpperCase();
			else
				newString += string.charAt(i);

			if(newString.substring(newString.length() - 1, newString.length()).equalsIgnoreCase(" "))
				cap = true;
			else
				cap = false;
		}

		return newString;
	}

}
