package jprofilegrid.view;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

import javax.swing.JFrame;

public class OpenWindowsMenu extends Menu implements ActionListener, WindowListener
{
	private static final long serialVersionUID = -101463428408916847L;
	private static Vector<JFrame> currentlyOpenWindows = new Vector<JFrame>();
	private Vector<MenuItem> menuItems = new Vector<MenuItem>();

	public OpenWindowsMenu()
	{
		super("Window");
	}

	public void updateOpenWindows()
	{
		removeAll();
		menuItems = new Vector<MenuItem>();
		for( int i = 0; i < currentlyOpenWindows.size(); i++ )
		{
			MenuItem currentWindow = new MenuItem(currentlyOpenWindows.get(i).getTitle());
			menuItems.add(currentWindow);
			currentWindow.addActionListener(this);
			add(currentWindow);
		}
	}

	public void actionPerformed(ActionEvent e)
	{
		for(int i = 0; i < menuItems.size(); i++)
			if(e.getSource() == menuItems.get(i))
				currentlyOpenWindows.get(i).toFront();
	}

	public void windowActivated(WindowEvent e)
	{
		if(!currentlyOpenWindows.contains((JFrame)e.getSource()))
			currentlyOpenWindows.add((JFrame)e.getSource());

		updateOpenWindows();
	}

	public void windowClosed(WindowEvent e)
	{
		if( currentlyOpenWindows.contains((JFrame)e.getSource()) )
			currentlyOpenWindows.remove((JFrame)e.getSource());

		updateOpenWindows();
	}

	public void windowClosing(WindowEvent e)
	{
		if( currentlyOpenWindows.contains((JFrame)e.getSource()) )
			currentlyOpenWindows.remove((JFrame)e.getSource());

		updateOpenWindows();
	}

	public void windowOpened(WindowEvent e)
	{
		if(!currentlyOpenWindows.contains((JFrame)e.getSource()))
			currentlyOpenWindows.add((JFrame)e.getSource());

		updateOpenWindows();
	}

	public void windowDeactivated(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
}
