package jprofilegrid.view.alignmentwindow;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;

import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;

public class AlignmentWindow extends JFrame implements ActionListener, AdjustmentListener
{
	private static final long serialVersionUID = 1L;

	private JTextArea speciesNamesJTextArea = new JTextArea(),
					  alignmentJTextArea = new JTextArea();
	private JScrollPane speciesNameScrollPane = new JScrollPane(speciesNamesJTextArea);
	private JScrollPane sequenceScrollPane = new JScrollPane(alignmentJTextArea);
	private JScrollBar verticalSequenceBar = new JScrollBar(JScrollBar.VERTICAL);
	private JScrollBar horizontalSequenceBar = new JScrollBar(JScrollBar.HORIZONTAL);
	private JScrollBar verticalSpeciesBar = new JScrollBar(JScrollBar.VERTICAL);
	private JScrollBar horizontalSpeciesBar = new JScrollBar(JScrollBar.HORIZONTAL);
	private MenuBar menuBar = new MenuBar();
	private Menu fileMenu = new Menu("File");
	private Menu aboutMenu = new Menu("About");
	private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
	private MenuItem quitMenuItem = new MenuItem("Quit");
	private int horizontalScrollPosition, verticalScrollPosition;
	private ProfileGridPresenter profileGridPresenter;

	private static Dimension DEFAULT_DIMENSION = new Dimension(300, 200);

	public AlignmentWindow(ProfileGridPresenter profileGridPresenter)
	{
		super("Alignment");
		setDefaultCloseOperation(AlignmentWindow.HIDE_ON_CLOSE);
		this.profileGridPresenter = profileGridPresenter;
		speciesNamesJTextArea.setAlignmentX(JTextArea.RIGHT_ALIGNMENT);
		verticalSpeciesBar.addAdjustmentListener(this);
		verticalSequenceBar.addAdjustmentListener(this);
		speciesNameScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
		sequenceScrollPane.setVerticalScrollBar(verticalSequenceBar);
		sequenceScrollPane.setHorizontalScrollBar(horizontalSequenceBar);
		speciesNameScrollPane.setVerticalScrollBar(verticalSpeciesBar);
		speciesNameScrollPane.setHorizontalScrollBar(horizontalSpeciesBar);
		alignmentJTextArea.setBackground(getBackground());
		alignmentJTextArea.setFont(new java.awt.Font("COURIER", java.awt.Font.PLAIN, 16));
		alignmentJTextArea.setEditable(false);
		speciesNamesJTextArea.setBackground(getBackground());
		speciesNamesJTextArea.setFont(new java.awt.Font("COURIER", java.awt.Font.PLAIN, 16));
		speciesNamesJTextArea.setEditable(false);
		setLayout(new GridBagLayout());
		GridBagConstraints constraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(constraints);
		constraints.fill = GridBagConstraints.BOTH;
		constraints.weightx = 10;
		constraints.weighty = 1;

		add(speciesNameScrollPane, constraints);

		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.weightx = 90;
		add(sequenceScrollPane, constraints);
		setSize(DEFAULT_DIMENSION);

		initializeMenuBar();
	}

	private void initializeMenuBar()
	{
		menuBar.add(fileMenu);
		OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
		addWindowListener(openWindowsMenu);
		menuBar.add(openWindowsMenu);
		menuBar.add(aboutMenu);
		quitMenuItem.addActionListener(this);
		aboutMenu.add(aboutMenuItem);
		aboutMenuItem.addActionListener(this);
		fileMenu.add(quitMenuItem);
		setMenuBar((menuBar));
	}

	public void updateSequences(String newText)
	{
		horizontalScrollPosition = horizontalSequenceBar.getValue();
		verticalScrollPosition = verticalSequenceBar.getValue();

		alignmentJTextArea.setText(newText);
		 SwingUtilities.invokeLater( new Runnable() {
				public void run()
				{
					horizontalSequenceBar.setValue( horizontalScrollPosition );
					verticalSequenceBar.setValue(verticalScrollPosition);
				}
				} );

	}

	public void updateNames(String newText)
	{
		speciesNamesJTextArea.setText(newText);
	}

	public void actionPerformed(ActionEvent e)
	{
		if( e.getSource() == quitMenuItem )
			System.exit(0);
		if( e.getSource() == aboutMenuItem )
			profileGridPresenter.showAboutDialog();
	}

	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		if( e.getSource() == verticalSequenceBar )
			verticalSpeciesBar.setValue(verticalSequenceBar.getValue());
	}
}
