package jprofilegrid.view.celldescription;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;

public class CellDescriptionJFrame extends JFrame implements ActionListener, ClipboardOwner
{
	private static final long serialVersionUID = 503347149005198654L;
	private JTextArea currentSelectedCell = new JTextArea("Select Cell");
	private JScrollPane scrollPane = new JScrollPane(currentSelectedCell);
	private JScrollBar verticalBar = new JScrollBar(JScrollBar.VERTICAL);
	private JScrollBar horizontalBar = new JScrollBar(JScrollBar.HORIZONTAL);

	private JButton showAlignmentJButton = new JButton("Show Alignment");

	private MenuBar menuBar = new MenuBar();
	private Menu fileMenu = new Menu("File");
	private Menu aboutMenu = new Menu("About");
	private Menu editMenu = new Menu("Edit");
	private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
	private MenuItem quitMenuItem = new MenuItem("Quit");
	private MenuItem copyItem = new MenuItem("Copy Sequence List");

	private ProfileGridPresenter profileGridPresenter;

	public CellDescriptionJFrame(ProfileGridPresenter profileGridPresenter)
	{
		super("Sequences");
		this.profileGridPresenter = profileGridPresenter;
		setLayout(new GridBagLayout());
		GridBagConstraints constraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(constraints);

		initializeMenuBar();
		scrollPane.setVerticalScrollBar(verticalBar);
		scrollPane.setHorizontalScrollBar(horizontalBar);
		currentSelectedCell.setEditable(false);
		constraints.fill = GridBagConstraints.BOTH;
		constraints.weightx = 1;
		constraints.weighty = 1;
		add(scrollPane, constraints);
		constraints.gridy++;
		constraints.weightx = 0;
		constraints.weighty = 0;
		add(showAlignmentJButton, constraints);

		showAlignmentJButton.addActionListener(this);
		setSize(150, 300);
	}

	private void initializeMenuBar()
	{
		menuBar.add(fileMenu);
		menuBar.add(editMenu);
		OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
		addWindowListener(openWindowsMenu);
		menuBar.add(openWindowsMenu);
		menuBar.add(aboutMenu);
		quitMenuItem.addActionListener(this);
		aboutMenu.add(aboutMenuItem);
		aboutMenuItem.addActionListener(this);
		editMenu.add(copyItem);
		copyItem.addActionListener(this);
		fileMenu.add(quitMenuItem);
		setMenuBar((menuBar));
	}

	public void setVisible(boolean visible)
	{
		currentSelectedCell.setBackground(getBackground());
		super.setVisible(visible);
	}

	public void actionPerformed(ActionEvent e)
	{
		if( e.getSource() == quitMenuItem )
			System.exit(0);
		if( e.getSource() == aboutMenuItem )
			profileGridPresenter.showAboutDialog();
		if( e.getSource() == copyItem )
			copySelectedText();
		if( e.getSource() == showAlignmentJButton)
			profileGridPresenter.showAlignmentWindow();
	}


	public void copySelectedText()
	{
		Clipboard clipboard = getToolkit ().getSystemClipboard ();
		clipboard.setContents(new StringSelection(currentSelectedCell.getText()), this);
	}

	public void lostOwnership(Clipboard clipboard, Transferable contents)
	{
	}

	public JTextArea getSequenceListJTextArea()
	{
		return currentSelectedCell;
	}
}